<?php return array (
  'author.submit.userGroupRequired' => 'Your account does not currently have a role permitting new submissions, such as Author. Please double-check your account; you may be able to add a suitable role yourself by editing your profile.',
  'author.submit.submissionCitations' => 'Provide a formatted list of references for works cited in this submission. Please separate individual references with a blank line.',
  'author.submission.roundStatus.reviewsReady' => 'New reviews have been submitted and are being considered by the editor.',
  'submission.confirm.message' => 'Your submission has been uploaded and is ready to be sent. You may go back to review and adjust any of the information you have entered before continuing. When you are ready, click "Finish Submission".',
  'submission.submit.submissionChecklist' => 'Submission Requirements',
  'submission.submit.submissionChecklistDescription' => 'You must read and acknowledge that you\'ve completed the requirements below before proceeding.',
  'submission.submit.submissionComplete' => 'Submission complete',
  'submission.submit.submissionCompleteThanks' => 'Thank you for your interest in publishing with {$contextName}.',
  'submission.submit.copyrightNoticeAgreementLabel' => 'Acknowledge the copyright statement',
  'submission.submit.copyrightNoticeAgree' => 'I agree to abide by the terms of the copyright statement.',
  'submission.submit.whatNext' => 'What Happens Next?',
  'submission.submit.whatNext.forNow' => 'For now, you can:',
  'submission.submit.whatNext.review' => 'Review this submission',
  'submission.submit.whatNext.create' => 'Create a new submission',
  'submission.submit.whatNext.return' => 'Return to your dashboard',
  'submission.submit.extendedMetadata' => 'Extended Metadata',
  'metadata.filters.crossref.settings.email.displayName' => 'CrossRef Registration Email',
  'metadata.filters.crossref.settings.email.validationMessage' => 'Please enter a valid CrossRef registration email. You can register your email for free on the CrossRef web site.',
  'metadata.filters.isbndb.settings.apiKey.displayName' => 'ISBNdb API Key',
  'metadata.filters.isbndb.settings.apiKey.validationMessage' => 'Please enter your ISBNdb API key. If you don\'t have a key yet you can request one for free from the ISBNdb project.',
  'metadata.filters.pubmed.settings.email.displayName' => 'PubMed Registration Email',
  'metadata.filters.pubmed.settings.email.validationMessage' => 'Please enter a valid PubMed registration email if you have one.',
  'metadata.filters.worldcat.settings.apiKey.displayName' => 'WorldCat API Key',
  'metadata.filters.worldcat.settings.apiKey.validationMessage' => 'Please enter a valid WorldCat API key if you have one.',
  'metadata.filters.paracite.settings.citationModule.displayName' => 'Citation Module',
  'metadata.filters.paracite.settings.citationModule.validationMessage' => 'Please select one of the given citation modules.',
  'metadata.filters.settings.isOptional.displayName' => 'Don\'t use by default (will still be available to the editor)',
  'metadata.filters.settings.isOptional.validationMessage' => 'Internal error. A non-valid value has been posted for the \'optional filter\' setting. Please report this as a bug.',
  'metadata.property.displayName.author' => 'Authors',
  'metadata.property.validationMessage.author' => 'For best results, authors should be entered in the following format: Coleman Jr, D. (Ralf) Dr.',
  'metadata.property.displayName.editor' => 'Editors',
  'metadata.property.validationMessage.editor' => 'For best results, editors should be entered in the following format: Coleman Jr, D. (Ralf) Dr.',
  'metadata.property.displayName.article-title' => 'Article/Paper Title',
  'metadata.property.validationMessage.article-title' => 'Please enter a valid article/paper title.',
  'metadata.property.displayName.source' => 'Publication Title',
  'metadata.property.validationMessage.source' => 'Please enter a valid publication title.',
  'metadata.property.displayName.date' => 'Publication Date',
  'metadata.property.validationMessage.date' => 'Please enter a valid publication date (format: YYYY-MM-DD).',
  'metadata.property.displayName.access-date' => 'Access Date',
  'metadata.property.validationMessage.access-date' => 'Please enter a valid access date (format: YYYY-MM-DD).',
  'metadata.property.displayName.issue' => 'Issue',
  'metadata.property.validationMessage.issue' => 'Please enter a valid issue.',
  'metadata.property.displayName.volume' => 'Volume',
  'metadata.property.validationMessage.volume' => 'Please enter a valid volume.',
  'metadata.property.displayName.season' => 'Season',
  'metadata.property.validationMessage.season' => 'Please enter a valid season identifier.',
  'metadata.property.displayName.chapter-title' => 'Chapter Title',
  'metadata.property.validationMessage.chapter-title' => 'Please enter a valid chapter title.',
  'metadata.property.displayName.edition' => 'Edition',
  'metadata.property.validationMessage.edition' => 'Please enter a valid edition.',
  'metadata.property.displayName.series' => 'Series',
  'metadata.property.validationMessage.series' => 'Please enter a valid series.',
  'metadata.property.displayName.supplement' => 'Supplement',
  'metadata.property.validationMessage.supplement' => 'Please enter a valid supplement.',
  'metadata.property.displayName.conf-date' => 'Conference Date',
  'metadata.property.validationMessage.conf-date' => 'Please enter a valid conference date (format: YYYY-MM-DD).',
  'metadata.property.displayName.conf-loc' => 'Conference Location',
  'metadata.property.validationMessage.conf-loc' => 'Please enter a valid conference location.',
  'metadata.property.displayName.conf-name' => 'Conference Name',
  'metadata.property.validationMessage.conf-name' => 'Please enter a valid conference name.',
  'metadata.property.displayName.conf-sponsor' => 'Conference Sponsor',
  'metadata.property.validationMessage.conf-sponsor' => 'Please enter a valid conference sponsor.',
  'metadata.property.displayName.institution' => 'Institution',
  'metadata.property.validationMessage.institution' => 'Please enter a valid institution.',
  'metadata.property.displayName.fpage' => 'First Page',
  'metadata.property.validationMessage.fpage' => 'Please enter a valid first page (must be a numeric value).',
  'metadata.property.displayName.lpage' => 'Last Page',
  'metadata.property.validationMessage.lpage' => 'Please enter a valid last page (must be a numeric value).',
  'metadata.property.displayName.size' => 'Number of Pages',
  'metadata.property.validationMessage.size' => 'Please enter a valid total number of pages (must be a numeric value).',
  'metadata.property.displayName.publisher-loc' => 'Publisher Location',
  'metadata.property.validationMessage.publisher-loc' => 'Please enter a valid publisher location.',
  'metadata.property.displayName.publisher-name' => 'Publisher Name',
  'metadata.property.validationMessage.publisher-name' => 'Please enter a valid publisher name.',
  'metadata.property.displayName.isbn' => 'ISBN',
  'metadata.property.validationMessage.isbn' => 'Please enter a valid ISBN (9 or 13 numbers).',
  'metadata.property.displayName.issn' => 'Print ISSN',
  'metadata.property.validationMessage.issn' => 'Please enter a valid Print ISSN.',
  'metadata.property.displayName.eissn' => 'eISSN',
  'metadata.property.validationMessage.eissn' => 'Please enter a valid eISSN.',
  'metadata.property.displayName.doi' => 'DOI',
  'metadata.property.validationMessage.doi' => 'Please enter a valid DOI.',
  'metadata.property.displayName.publisher-id' => 'Custom Publication ID',
  'metadata.property.validationMessage.publisher-id' => 'Please enter a valid custom publication ID.',
  'metadata.property.displayName.coden' => 'CODEN',
  'metadata.property.validationMessage.coden' => 'Please enter a valid CODEN.',
  'metadata.property.displayName.sici' => 'SICI',
  'metadata.property.validationMessage.sici' => 'Please enter a valid SICI.',
  'metadata.property.displayName.pmid' => 'PMID',
  'metadata.property.validationMessage.pmid' => 'Please enter a valid PMID.',
  'metadata.property.displayName.uri' => 'Link to the Publication',
  'metadata.property.validationMessage.uri' => 'Please enter a valid alternative link to the publication.',
  'metadata.property.displayName.comment' => 'Comment',
  'metadata.property.validationMessage.comment' => 'Please enter a valid comment.',
  'metadata.property.displayName.annotation' => 'Annotation',
  'metadata.property.validationMessage.annotation' => 'Please enter a valid annotation.',
  'metadata.property.displayName.publication-type' => 'Publication Type',
  'metadata.property.validationMessage.publication-type' => 'Please make sure that you always set a publication type. Currently supported values are book (for books or book chapters) and journal (for journal articles). Otherwise the citation output formatting will not work correctly.',
  'metadata.property.displayName.title-type' => 'Title Type',
  'metadata.property.validationMessage.title-type' => 'Please make sure that you set a valid title type. Supported values are \'abbreviated\', \'translated\', \'alternative\' and \'uniform\'.',
  'metadata.property.displayName.nonSort' => 'Part of title ignored while sorting',
  'metadata.property.validationMessage.nonSort' => 'Please only enter the initial characters of the title that should be ignored when sorting the title.',
  'metadata.property.displayName.title' => 'Title',
  'metadata.property.validationMessage.title' => 'Please enter a valid title.',
  'metadata.property.displayName.subTitle' => 'Subtitle',
  'metadata.property.validationMessage.subTitle' => 'Please enter a valid subtitle.',
  'metadata.property.displayName.partNumber' => 'Part Number',
  'metadata.property.validationMessage.partNumber' => 'Please enter a valid part number.',
  'metadata.property.displayName.partName' => 'Part Name',
  'metadata.property.validationMessage.partName' => 'Please enter a valid part name.',
  'metadata.property.displayName.name-type' => 'Name Type',
  'metadata.property.validationMessage.name-type' => 'Please make sure that you set a valid name type. Supported values are \'personal\', \'corporate\' and \'conference\'.',
  'common.queue.long.submissionsUnassigned' => 'Unassigned',
  'common.queue.long.myAssigned' => 'My Assigned',
  'common.queue.long.submissionsArchived' => 'Archived Submissions',
  'submission.authors' => 'Authors',
  'submission.authorBiographies' => 'Author Biographies',
  'submission.shortAuthor' => '{$author} et al.',
  'submission.mySubmissions' => 'My Authored',
  'submission.addFile' => 'Upload File',
  'submission.agencies' => 'Agencies',
  'submission.abstractViews' => 'Abstract Views',
  'submission.accepted' => 'Accepted',
  'submission.acknowledge' => 'Acknowledge',
  'submission.addSuppFile' => 'Add a Supplementary File',
  'submission.ask' => 'Ask',
  'submission.attachedFile' => 'Attached file',
  'submission.backToSubmissionEditing' => 'Back to Submission Editing',
  'submission.changeComments' => 'Change to',
  'submission.changeFile' => 'Change File',
  'submission.citations' => 'References',
  'submission.citations.editor.citationlist.approved' => 'Approved',
  'submission.citations.editor.citationlist.deleteCitationConfirmation' => 'Are you sure you want to delete this citation?',
  'submission.citations.editor.citationlist.errorDeletingCitation' => 'An error occurred while trying to delete the citation.  Please report this as a bug.',
  'submission.citations.editor.citationlist.newCitation' => 'New Citation',
  'submission.citations.editor.citationlist.notApproved' => 'Not Approved',
  'submission.citations.editor.citationlist.title' => 'Edit Citations',
  'submission.citations.editor.clickToEdit' => 'Click to edit.',
  'submission.citations.editor.details.authorQuery' => 'Ask Author',
  'submission.citations.editor.details.authorQueryBody' => 'Your message to the author:',
  'submission.citations.editor.details.authorQueryExplanation' => 'You can ask the author for further information about the current citation. Clicking the "Send" button below will send your message as an email to the author.',
  'submission.citations.editor.details.authorQuerySubject' => 'Subject:',
  'submission.citations.editor.details.cannotSelectDefaultForLabel' => 'You cannot unset a field label. Please delete the field if you don\'t need it',
  'submission.citations.editor.details.checkInGoogleScholar' => 'Check in Google Scholar',
  'submission.citations.editor.details.changeFieldInfo' => 'Type first few letters to select...',
  'submission.citations.editor.details.citationExportPreview' => 'Citation Export Preview',
  'submission.citations.editor.details.citationImprovementResultsActive' => 'Expert internal citation service results (click to close)',
  'submission.citations.editor.details.citationImprovementResultsInactive' => 'Expert internal citation service results (click to open)',
  'submission.citations.editor.details.citationServices' => 'Citation Services',
  'submission.citations.editor.details.clickToDismissMessage' => 'You can click the text of a message to dismiss it.',
  'submission.citations.editor.details.dataSaved' => 'Your changes have been saved.',
  'submission.citations.editor.details.editRawCitationDatabaseServices' => 'Select Citation Database Services:',
  'submission.citations.editor.details.editRawCitationExpertSettingsActive' => 'Expert citation editing settings (Click to close)',
  'submission.citations.editor.details.editRawCitationExpertSettingsInactive' => 'Expert citation editing settings (Click to open)',
  'submission.citations.editor.details.editRawCitationExtractionServices' => 'Select Citation Extraction Services:',
  'submission.citations.editor.details.editRawCitationFilterValidationError' => 'Internal error: Invalid filter selection. Please submit a bug report.',
  'submission.citations.editor.details.explainImprovementOptions' => 'If you did not get satisfactory results by default then you have various options to improve the citation. It often helps to manually edit important fields (e.g. title and author) and then try the citation services again. If that doesn\'t help you can still query Google Scholar or ask the author for details.',
  'submission.citations.editor.details.googleScholar' => 'Google Scholar',
  'submission.citations.editor.details.googleScholarExplanation' => 'If a matched citation wasn\'t found in any of the connected citation services you can still search for a match in Google Scholar. Unfortunately, Google Scholar does not provide a field-based interface for its data which we could use, which means there is no way to automatically return data into this Assistant. You will have to copy and paste information manually from the Google result page to your fields.',
  'submission.citations.editor.details.manualEditing' => 'Manual Editing',
  'submission.citations.editor.details.messages' => 'Please note (click on messages to dismiss them)',
  'submission.citations.editor.details.newFieldInfo' => '...click here to add a new field...',
  'submission.citations.editor.details.queryCitation' => 'Re-Query Citation Services',
  'submission.citations.editor.details.queryGoogleScholar' => 'Search in Google Scholar',
  'submission.citations.editor.details.processRawCitation' => 'Process',
  'submission.citations.editor.details.processRawCitationGoAhead' => 'Go Ahead',
  'submission.citations.editor.details.processRawCitationTitle' => 'Changing Original Citation',
  'submission.citations.editor.details.processRawCitationWarning' => 'You are about to change the original citation text. If you do that then all fields will be replaced with newly generated values. This deletes manual changes you might already have made.',
  'submission.citations.editor.details.saveAndApprove' => 'Save And Approve',
  'submission.citations.editor.details.saveAndRevokeApproval' => 'Revoke Approval',
  'submission.citations.editor.details.sendAuthorQuery' => 'Send Message',
  'submission.citations.editor.details.sendAuthorQuerySuccess' => 'Message sent!',
  'submission.citations.editor.details.sourceResultsUse' => 'Use',
  'submission.citations.editor.details.sourceResultsUseAll' => 'Use All',
  'submission.citations.editor.details.sourceResultsUseAllExplanation' => 'Click to transport all result fields from this source directly to your field list',
  'submission.citations.editor.details.sourceResultsUseExplanation' => 'Click to transport this result field directly to your field list',
  'submission.citations.editor.details.rawCitation' => 'Original Citation Text',
  'submission.citations.editor.details.rawCitationRequired' => 'A citation text is required.',
  'submission.citations.editor.details.unsavedChanges' => 'The citation contains unsaved data. Please click the "Save" button to keep the changes or the "Cancel" button to undo the changes.',
  'submission.citations.editor.details.dontShowMessageAgain' => 'Don\'t show this message again.',
  'submission.citations.editor.edit' => 'Edit Citations',
  'submission.citations.editor.export' => 'Export Citations',
  'submission.citations.editor.export.exportDescription' => '<a id="markForExport" href="">Click here</a> to select all of the generated output. You can then copy and paste it into your document.',
  'submission.citations.editor.export.filterSelectionDescription' => 'Please select one of the following export options.',
  'submission.citations.editor.export.filterSelectionError' => 'You did not select one of the output options.',
  'submission.citations.editor.export.foundUnapprovedCitationsMessage' => '<p>You have not yet approved all citations. Please go to the <strong>Edit Citations</strong> tab and make sure you have approved all citations before you try to export them. Approved citations are marked with a dark blue stripe to the left.</p>',
  'submission.citations.editor.export.noExportOutput' => 'The \'{$filterName}\' output filter has produced an error. Please file a bug report.',
  'submission.citations.editor.export.pleaseSelectXmlFilter' => 'XML output options:',
  'submission.citations.editor.export.pleaseSelectPlaintextFilter' => 'Citation style output (experimental only!):',
  'submission.citations.editor.introduction' => 'Introduction',
  'submission.citations.editor.introduction.introductionMessage' => '<h4>Welcome to the Citation Markup Assistant!</h4>
	<p>With this assistant you can mark up author-provided citations for export to NLM 2.3 or 3.0 XML galleys, or alternatively as text-based output. This tool first attempts to automatically extract and recognize citations as they have been provided, but you can step in and edit the results at any time.</p>
	<ul>
		<li><p><strong>Configuring the Assistant</strong></p>
		<p>The Citation Markup Assistant is configured by the journal manager in <a href="{$citationSetupUrl}">Journal Setup Step 3.7: Citation Markup Assistant</a>. Different citation extraction and checking tools can be added, configured, and deleted. For more information, contact the journal manager.</p></li>
		<li><p><strong>Navigating the Assistant Interface</strong></p>
		<p>To switch between <strong>Introduction</strong>, <strong>Edit Citations</strong> and <strong>Export Citations</strong> tabs, click the tab titles. To expand the citation interface, click the <strong>Fullscreen</strong> button. To return to a normal interface from the expanded citation interface, click the <strong>Fullscreen Off</strong> button. To remove this introductory tab entirely, click the button below.</p></li>
		<li><p><strong>Requesting Citations</strong></p>
		<p>If the Citation Markup Assistant has been enabled by the journal manager, authors will be prompted for a list of references during article submission. These references will be requested separately from the submission document itself. After submission, authors can also modify their list of references at any time by editing the submission\'s metadata; note that this will overwrite any modifications that you have made to the citations using this tool.</p></li>
		<li><p><strong>Editing Citations</strong></p>
		<p>The Citation Markup Assistant will attempt to identify and extract individual citations from the author\'s list of references. You can systematically check each citation extraction attempt for accuracy against a number of external databases; edit incorrect citation information and add new information; approve or delete citations; and add new citations.</p>
		<p>All final citations for a submission must be approved before they can be exported.</p></li>
		<li><p><strong>Exporting Citations</strong></p>
 		<p>Citations can be exported as XML or text. XML export options currently include <a href="http://dtd.nlm.nih.gov/publishing/">NLM Journal Publishing</a> 2.3 and 3.0 <a href="http://www.ncbi.nlm.nih.gov/pmc/pmcdoc/tagging-guidelines/article/tags.html#el-reflist">ref-list XML</a>. Selecting one of these options outputs an XML-encoded ref-list snippet that can be copied and pasted into an NLM XML galley.</p>
		<p>Experimental text export options include ABNT, APA, MLA and Vancouver citation output styles. These options provide a text output that can be copied and pasted into a text-based article galley (for example into Microsoft Word or OpenOffice; Adobe InDesign; etc.). Each citation includes an embedded link to automatically search for that citation in Google Scholar.</p></li>
	</ul>',
  'submission.citations.editor.loadMessage' => 'Please wait for the citation markup assistant to load.',
  'submission.citations.editor.pleaseImportCitationsFirst' => '<p>There are no citations for this article.</p><p>Please go to the article\'s <a href="{$articleMetadataUrl}">metadata page</a> and enter a reference list or add references manually using the add item button of the editor.</p>',
  'submission.citations.editor.pleaseSelect' => 'Please select...',
  'submission.citations.editor.unprocessedCitations' => 'The citations of this article are still being processed on the server. The current citation list only contains already processed citations. Please click the refresh button to see citations that have been processed in the meantime.',
  'submission.citations.editor.unprocessedCitationsButton' => 'Refresh Citation List',
  'submission.citations.editor.unprocessedCitationsButtonTitle' => 'Click to refresh the citation list.',
  'submission.citations.filter.invalidMetadata' => 'An error occurred in {$filterName}: One of the data elements returned from the data source (e.g. a web service) did not conform to the internal meta-data format. Therefore the data source\'s results were rejected. Please file this as a bug.',
  'submission.citations.filter.noResultFromFilterError' => 'Several citation services did not return any results. You can try to manually edit citation fields and then query citation services again to improve results. If this doesn\'t help then the citation does not exist in any of the connected databases.',
  'submission.citations.filter.unsupportedPublicationType' => 'Unsupported or missing publication type. Please manually edit the citation and enter a publication type (allowed types are \'book\', \'journal\', \'thesis\' and \'conf-proc\').',
  'submission.citations.filter.webserviceError' => 'The {$filterName}\'s web service call has returned an error when called with the following URL: {$webserviceUrl}. It may be that the web service is temporarily unavailable. You\'ll still be able to work with the remaining services and save your results. You can also try again later. If the error persists then please ask the manager to deactivate this service and open a bug report.',
  'submission.citations.filter.webserviceResultTransformationError' => 'An error occurred in {$filterName}: The transformation of XML results (e.g. from a web service) into field-based meta-data failed. The reason probably is that the web service returned invalid or incomplete data. Please file this as a bug.',
  'submission.citations.metadata.changeWarning' => 'Are you sure you want to update your references list? If you click OK, any changes made by the Editors will be overwritten. If you are not sure whether you should make changes to the references list, please contact the Editor in charge of your submission.',
  'submission.comments.addComment' => 'Add Comment',
  'submission.comments.comments' => 'Comments',
  'submission.comments.confirmDelete' => 'Are you sure you would like to delete this comment?',
  'submission.comments.corrections' => 'Corrections',
  'submission.comments.editComment' => 'Edit Comment',
  'submission.comments.importPeerReviews' => 'Import Peer Reviews',
  'submission.comments.addReviews' => 'Add Reviews to Email',
  'submission.comments.importPeerReviews.reviewerLetter' => 'Reviewer {$reviewerLetter}:',
  'submission.comments.noComments' => 'No Comments',
  'submission.comments.noReviews' => 'No Reviews',
  'submission.comments.review' => 'Review',
  'submission.comments.sendDecisionToReviewers' => 'Send Reviewers editorial decision',
  'submission.comments.subject' => 'Subject',
  'submission.complete' => 'Complete',
  'submission.contributors' => 'List of Contributors',
  'submission.copyedited' => 'Copyedited',
  'submission.copyediting' => 'Copyediting',
  'submission.queryNoteFiles' => 'Discussion Files',
  'submission.coverage' => 'Coverage Information',
  'submission.done' => 'Done',
  'submission.dueDate' => 'Due Date',
  'submission.due' => 'Due',
  'submission.editing' => 'Editing',
  'submission.editMetadata' => 'Edit Metadata',
  'submission.editorial' => 'Copyediting',
  'submission.email.backToEmailLog' => 'Back to Email Log',
  'submission.email.confirmClearLog' => 'Are you sure you want to clear the email log for this submission?',
  'submission.email.confirmDeleteLogEntry' => 'Are you sure you want to delete this email log entry?',
  'submission.email.deleteLogEntry' => 'Delete Log Entry',
  'submission.emailLog' => 'Email Log',
  'submission.event.backToEventLog' => 'Back to Event Log',
  'submission.event.confirmClearLog' => 'Are you sure you want to clear the event log for this submission?',
  'submission.event.confirmDeleteLogEntry' => 'Are you sure you want to delete this event log entry?',
  'submission.event.deleteLogEntry' => 'Delete Log Entry',
  'submission.event.submissionSubmitted' => 'Initial submission completed.',
  'submission.event.fileUploaded' => 'A file "{$originalFileName}" was uploaded for submission {$submissionId} by {$username}.',
  'submission.event.fileRevised' => 'Revision "{$name}" (file ID {$fileId}-{$revision}) was uploaded.',
  'submission.event.general.metadataUpdated' => 'Submission metadata updated',
  'submission.event.general.suppFileUpdated' => 'Submission file updated',
  'submission.event.participantAdded' => '{$name} was assigned to this submission as a {$userGroupName}.',
  'submission.event.reviewer.reviewAcceptedByProxy' => 'Review assignment accepted by proxy',
  'submission.event.reviewer.reviewAccepted' => 'Review assignment accepted',
  'submission.event.reviewer.reviewCancelled' => 'Review assignment cancelled',
  'submission.event.reviewer.reviewDeclined' => 'Review assignment declined',
  'submission.event.reviewer.reviewDueDate' => 'Review due date modified',
  'submission.event.reviewer.reviewerAssigned' => 'Reviewer assigned to submission',
  'submission.event.reviewer.reviewerRated' => 'Reviewer rating submitted',
  'submission.event.reviewer.reviewerUnassigned' => 'Reviewer unassigned from submission',
  'submission.event.reviewer.reviewFile' => 'Review file updated',
  'submission.event.reviewer.reviewInitiated' => 'Review assignment initiated',
  'submission.event.reviewer.reviewRecommendation' => 'Review recommendation file',
  'submission.event.reviewer.reviewReinitiated' => 'Review assignment reinitiated',
  'submission.event.reviewer.reviewResubmitted' => 'Review resubmitted',
  'submission.event.reviewer.reviewRevision' => 'Reviewer revisions file updated',
  'submission.event.subjectPrefix' => 'An email has been sent:',
  'submission.event.viewEmail' => 'View Email',
  'submission.files' => 'Files',
  'submission.files.downloadAll' => 'Download All Files',
  'submission.galley' => 'Galley',
  'submission.history.clearLog' => 'Clear Log',
  'submission.history' => 'History',
  'submission.history.noLogEntries' => 'No log entries.',
  'submission.history.recentLogEntries' => 'Recent Entries',
  'submission.history.submissionEmailLog' => 'Email Log',
  'submission.history.submissionEventLog' => 'Event Log',
  'submission.history.submissionNotes' => 'Submission Notes',
  'submission.history.viewLog' => 'View Log',
  'submission.howToCite' => 'How to Cite',
  'submission.howToCite.citationFormats' => 'Citation Formats',
  'submission.indexing' => 'Indexing',
  'submission.initiated' => 'Initiated',
  'submission.identifiers' => 'Identifiers',
  'submission.publisherId' => 'Public URL identifier',
  'submission.informationCenter.submissionInfo' => 'Submission Info',
  'submission.informationCenter.metadata' => 'Metadata',
  'submission.informationCenter.notes' => 'Notes',
  'submission.informationCenter.history' => 'History',
  'submission.informationCenter.history.allEvents' => 'Show events from prior versions',
  'submission.stageParticipants.notify' => 'Notify',
  'submission.lastModified' => 'Last modified',
  'submission.layout.addGalley' => 'Add a Layout Galley',
  'submission.layout.confirmDeleteGalley' => 'Are you sure you want to permanently delete this galley?',
  'submission.layout.confirmDeleteGalleyImage' => 'Are you sure you want to remove this image from the galley?',
  'submission.layout.confirmDeleteSupplementaryFile' => 'Are you sure you want to permanently delete this supplementary file?',
  'submission.layout.deleteGalleyStylesheet' => 'Delete this style sheet.',
  'submission.layout.editGalley' => 'Edit a Layout Galley',
  'submission.layout.galleyFormat' => 'Galley Format',
  'submission.layout.galleyHTMLData' => 'HTML Galley Files',
  'submission.layout.galleyImages' => 'Images',
  'submission.layout.galleyLabel' => 'Galley Label',
  'submission.layout.galleyLabelInstructions' => 'Typically used to identify the file format (e.g. PDF, HTML, etc.).',
  'submission.layout.galleyLabelRequired' => 'A galley label is required.',
  'submission.layout.galleyLanguageRequired' => 'A galley language is required.',
  'submission.layout.galleyLocaleRequired' => 'A galley locale is required.',
  'submission.layout.galleyRemoteURL' => 'Remote URL',
  'submission.layout.galleyRemoteURLValid' => 'Please provide a valid remote URL (include http://).',
  'submission.layout.galleyNoImages' => 'No images',
  'submission.layout.galleys' => 'Galleys',
  'submission.layout.galleyStylesheet' => 'Stylesheet File',
  'submission.layout.galleyStyle' => 'Style',
  'submission.layout.initialGalleyCreation' => 'Initial Galley Creation',
  'submission.layout.layoutFile' => 'Layout File',
  'submission.layout' => 'Layout',
  'submission.layout.layoutVersion' => 'Layout Version',
  'submission.layout.newGalley' => 'Create New Galley',
  'submission.layout.newSupplementaryFile' => 'Upload New Supplementary File',
  'submission.layout.noStyleFile' => 'No style sheet file has been added to this galley.',
  'submission.layout.supplementaryFiles' => 'Supplementary File Review',
  'submission.layout.viewingGalley' => 'Viewing Submission Galley',
  'submission.layout.viewProof' => 'View Proof',
  'submission.metadata' => 'Submission Metadata',
  'submission.noReviewAssignments' => 'No Review Assignments',
  'submission.notes.addNewNote' => 'Add New Note',
  'submission.notes.attachedFile' => 'File Attachment',
  'submission.notes.backToSubmissionNotes' => 'Back To Submission Notes',
  'submission.notes.breadcrumb' => 'Notes',
  'submission.notes.clearAllNotes' => 'Clear All Notes',
  'submission.notes.collapseNotes' => 'Collapse Notes',
  'submission.notes.confirmDeleteAll' => 'Remove All Submission Notes?',
  'submission.notes.confirmDelete' => 'Remove This Submission Note?',
  'submission.notes.createNewNote' => 'Create New Note',
  'submission.notes.deleteNote' => 'Delete Note',
  'submission.notes.editNote' => 'Edit Note',
  'submission.notes.expandNotes' => 'Expand Notes',
  'submission.notes.noSubmissionNotes' => 'No Submission Notes',
  'submission.notes.removeUploadedFile' => 'Remove Uploaded File',
  'submission.notes' => 'Submission Notes',
  'submission.notes.updateNote' => 'Update Note',
  'submission.notes.viewNotes' => 'View Notes',
  'submission.originalFile' => 'Original file',
  'submission.page.editing' => '#{$id} Editing',
  'submission.page.history' => '#{$id} History',
  'submission.page.review' => '#{$id} Review',
  'submission.page.summary' => '#{$id} Summary',
  'submission.page.citations' => '#{$id} Citations',
  'submission.peerReview' => 'Peer&nbsp;Review',
  'submission.production' => 'Production',
  'submission.recommendation' => 'Recommendation: {$recommendation}',
  'submission.rejected' => 'Rejected',
  'submission.request' => 'Request',
  'submission.response' => 'Response',
  'submission.restrictions' => 'Restrictions',
  'submission.reviewMetadata' => 'Review Metadata',
  'submission.review' => 'Review',
  'submission.reviewed' => 'Reviewed',
  'submission.reviewVersion' => 'Review Version',
  'submission.rights' => 'Rights',
  'submission.rights.tip' => 'If you wish, you may enter a brief statement about the access rights held in or over this submission.',
  'submissions.active' => 'Active',
  'submissions.archived' => 'Archived',
  'submission.saveMetadata' => 'Save Metadata',
  'submissions.completed' => 'Completed',
  'submissions.declined' => 'Declined',
  'submissions.incomplete' => 'Incomplete',
  'submissions.noSubmissions' => 'No Submissions',
  'submissions.queuedEditing' => 'In Editing',
  'submissions.queued' => 'Queued',
  'submissions.queuedUnassigned' => 'Awaiting assignment',
  'submissions.ruling' => 'Ruling',
  'submission.source' => 'Source',
  'submission.source.tip' => 'Is this submission derived from another resource? If so, you may enter a URL or description of that resource.',
  'submissions.submit' => 'Submit',
  'submissions.submitted' => 'Submitted',
  'submission.submission' => 'Submission',
  'submission.submissionTitle' => 'Submission Title:',
  'submission.start' => 'Start',
  'submission.submissionHistory' => 'Submission History',
  'submission.submissionManuscript' => 'Submission Manuscript',
  'submission.submissionReview' => 'Submission Review',
  'submission.submitter' => 'Submitter',
  'submission.submit.finishSubmission' => 'Finish Submission',
  'submission.submit.selectFile' => 'Select File',
  'submission.submit.fileInformation' => 'File Information',
  'submission.submit.fileAdded' => 'File Added',
  'submission.submit.includeInBrowse' => 'Include this contributor in browse lists?',
  'submission.submit.newFile' => 'Add Another File',
  'submission.submit.metadataForm' => 'Additional Refinements',
  'submission.submit.metadataForm.tip' => 'Add additional information for your submission.  Press \'enter\' after each term.',
  'submission.submit.submissionLocale' => 'Submission Language',
  'submission.submit.submissionLocaleDescription' => 'This press accepts submissions in several languages. Choose the primary language of the submission from the pulldown below.',
  'submission.submit.submissionFiles' => 'Submission Files',
  'submission.submit.dependentFiles' => 'Dependent Files',
  'submission.manageDependentFiles' => 'Manage Dependent Files',
  'submission.upload.dependent' => 'Upload a Dependent File',
  'submission.upload.query' => 'Upload a Discussion File',
  'submission.summary' => 'Summary',
  'submission.supplementaryFiles' => 'Supplementary Files',
  'submission.supportingAgencies' => 'Supporting Agencies',
  'submission.currentAgencies' => 'Current Agencies',
  'submission.indexingInformation' => 'Indexing Information',
  'submission.titleAndAbstract' => 'Title and Abstract',
  'submission.type.tip' => 'The submission type is usually one of \'image\', \'text\', or other multimedia types including \'software\' or \'interactive\'.  Please choose the one most relevant for your submission.  Examples may be found at <a target="_blank" href="http://dublincore.org/documents/2001/04/12/usageguide/generic.shtml#type">http://dublincore.org/documents/2001/04/12/usageguide/generic.shtml#type</a>',
  'submission.underway' => 'Underway',
  'submission.uploadFileTo' => 'Upload file to',
  'submission.createRemote' => 'Create remote',
  'submission.viewMetadata' => 'View Metadata',
  'submission.views' => 'Views',
  'submission.uploadSuccessful' => 'Your file has been uploaded.',
  'submission.loadMessage' => 'Please wait while your file is uploaded to the server.',
  'submission.artworkFileDetails' => 'Artwork File Details',
  'submission.fileDetails' => 'File Details',
  'submission.nameRequired' => 'A name is required for this item.',
  'submission.date.mmdd' => 'MM-DD',
  'submission.date.yyyymmdd' => 'YYYY-MM-DD',
  'submission.submit.selectPrincipalContact' => 'Principal contact for editorial correspondence.',
  'submission.submit.contributorRole' => 'Contributor\'s role',
  'submission.submit.addAuthor' => 'Add Contributor',
  'submission.form.name' => 'Name the file (e.g., Manuscript; Table 1)',
  'submission.form.replaceExisting' => 'Replacing an Existing File?',
  'workflow.review.internalReview' => 'Internal Review',
  'workflow.stage.any' => 'Any Stage',
  'workflow.stage' => 'Stage',
  'submission.status.editorial' => 'In Copyediting',
  'submission.status.production' => 'In Proofreading',
  'submission.status.review' => 'In Review',
  'submission.status.submission' => 'Awaiting Editor Decision',
  'submission.status.unassigned' => 'Unassigned',
  'submission.status.declined' => 'Declined',
  'submission.status.published' => 'Published',
  'submission.submit.uploadStep' => '1. Upload File',
  'submission.submit.uploadSubmissionFile' => 'Upload Submission File',
  'submission.submit.metadataStep' => '2. Review Details',
  'submission.submit.finishingUpStep' => '3. Confirm',
  'submission.submit.fileNameRequired' => 'You must enter a file name for this file',
  'submission.upload.noGenre' => 'Missing or invalid component!',
  'submission.upload.invalidUserGroup' => 'Missing or invalid user group!',
  'submission.upload.possibleRevision' => 'Possible Duplication or Revision Detected',
  'submission.upload.possibleRevisionDescription' => 'The name of the uploaded file resembles the name of a previously uploaded file, "{$revisedFileName}." Is this file intended to replace "{$revisedFileName}"? If so, select the file below. Otherwise, select "This is not a revision of an existing file" before proceeding.',
  'submission.upload.selectMandatoryFileToRevise' => 'Please select the file you would like to revise.',
  'submission.upload.selectOptionalFileToRevise' => 'If you are uploading a revision of an existing file, please indicate which file.',
  'submission.upload.uploadNewFile' => 'This is not a revision of an existing file',
  'submission.upload.userGroup' => 'Upload this file in my role as...',
  'submission.upload.userGroupDescription' => 'If you are submitting an Edited Volume, you should upload all volume chapters individually, under your role as volume editor.',
  'submission.upload.uploadLibraryFile' => 'Upload a Library File',
  'submission.upload.libraryCategory' => 'Submission Document Category',
  'submission.upload.finalDraft' => 'Upload File',
  'submission.upload.copyeditedVersion' => 'Upload Copyedited File',
  'submission.upload.fairCopy' => 'Upload Fair Copy',
  'submission.upload.uploadFiles' => 'Upload Files',
  'submission.upload.response.description' => 'After reviewing the assigned file, record any comments on the file below, and/or upload an annotated copy of the file (or another file).',
  'submission.upload.productionReady' => 'Upload a Production Ready File',
  'submission.upload.proof' => 'Upload a File Ready for Publication',
  'submission.upload.noAvailableReviewFiles' => 'There are no files for you to revise at this time.',
  'editor.submission.roundStatus.revisionsRequested' => 'Revisions have been requested.',
  'editor.submission.roundStatus.resubmitted' => 'Submission has been resubmitted for review.',
  'editor.submission.roundStatus.sentToExternal' => 'Sent to external review.',
  'editor.submission.roundStatus.accepted' => 'Submission accepted.',
  'editor.submission.roundStatus.declined' => 'Submission declined.',
  'editor.submission.roundStatus.pendingReviewers' => 'Waiting for reviewers to be selected.',
  'editor.submission.roundStatus.pendingReviews' => 'Awaiting responses from reviewers.',
  'editor.submission.roundStatus.reviewsReady' => 'New reviews have been submitted.',
  'editor.submission.roundStatus.reviewsCompleted' => 'Reviews completed.',
  'editor.submission.stageParticipants' => 'Participants',
  'editor.submission.noneAssigned' => 'None Assigned',
  'editor.submission.participant' => 'Participant',
  'editor.submission.addStageParticipant' => 'Add Participant',
  'editor.submission.addStageParticipant.userGroup' => 'Users are assigned to stages of the workflow by user group. Any user assigned to this stage will automatically be assigned to other stages to which their user group has been assigned. This is commonly reserved for editors, authors and translators.',
  'editor.submission.removeStageParticipant' => 'Remove Participant',
  'editor.submission.removeStageParticipant.description' => 'You are about to remove this participant from <strong>all</strong> stages. If the user also have pending auditor tasks, they will be removed too.',
  'editor.submission.addStageParticipant.form.userGroupRequired' => 'You must select a user group.',
  'editor.submission.addStageParticipant.form.userRequired' => 'You must select a user for the specified user group.',
  'editor.submission.decision' => 'Decision',
  'editor.submission.decision.accept' => 'Send to Copyediting',
  'editor.submission.decision.requestRevisions' => 'Request Revisions',
  'editor.submission.decision.resubmit' => 'Resubmit for Review',
  'editor.submission.decision.decline' => 'Decline Submission',
  'editor.submission.decision.sendToProduction' => 'Send To Production',
  'editor.submission.decision.sendInternalReview' => 'Send to Internal Review',
  'editor.submission.decision.approveProofsDescription' => 'The page proof file must be checked as approved to be made Available. Do you want to approve it?',
  'editor.submission.decision.approveProofs' => 'Approve Proofs',
  'editor.submission.decision.disapproveProofsDescription' => 'This file proof will no longer be publicly available for download or purchase. Do you want to disapprove it?',
  'submission.currentStage' => 'Current stage',
  'submission.noActionRequired' => 'No action required',
  'submission.actionNeeded' => 'Needs action',
  'reviewer.submission.reviewFiles' => 'Review Files',
  'submission.submit.currentFile' => 'Current file',
  'submission.finalDraft' => 'Draft Files',
  'editor.submission.addAuditorError' => 'There was an error trying to assign the auditor. Please Try again.',
  'submission.event.fileDeleted' => 'A file "{$originalFileName}" was deleted for submission {$submissionId} by {$username}.',
  'submission.event.revisionUploaded' => 'A file revision "{$originalFileName}" was uploaded for submission {$submissionId} by {$username}.',
  'submission.event.revisionDeleted' => 'A file revision "{$originalFileName}" was deleted for submission {$submissionId} by {$username}.',
  'submission.event.lastRevisionDeleted' => 'A file "{$title}" had its last revision removed by {$username}.',
  'submission.event.fileAuditorAdded' => '"{$name}" ({$username}) was added as an auditor for the file "{$file}."',
  'submission.event.fileAuditorCleared' => '"{$name}" ({$username}) was removed as an auditor for the file "{$file}."',
  'submission.event.fileAuditUploaded' => '"{$name}" ({$username}) has completed an audit and uploaded "{$file}."',
  'submission.event.signoffSignoff' => '"{$name}" ({$username}) has signed off on the signoff for "{$file}."',
  'submission.event.proofsApproved' => '"{$name}" ({$username}) has approved the proofs for "{$formatName}."',
  'submission.overview' => 'Submission Overview',
  'submission.description' => 'Description',
  'submission.stageNotInitiated' => 'Stage not initiated.',
  'submission.documents' => 'Submission Documents',
  'notification.type.copyeditorRequest' => 'You have been asked to review copyedits for "{$title}".',
  'notification.type.layouteditorRequest' => 'You have been asked to review layouts for "{$title}".',
  'notification.type.indexRequest' => 'You have been asked to create an index for "{$title}".',
  'notification.type.editorDecisionTitle' => 'Latest editor decision.',
  'notification.type.editorDecisionAccept' => 'Submission accepted.',
  'notification.type.editorDecisionExternalReview' => 'External review process started.',
  'notification.type.editorDecisionPendingRevisions' => 'Revision required.',
  'notification.type.editorDecisionResubmit' => 'Resubmit for review.',
  'notification.type.editorDecisionDecline' => 'Submission declined.',
  'notification.type.editorDecisionSendToProduction' => 'Production process started.',
  'notification.uploadedResponse' => 'Response uploaded.',
  'notification.type.editorAssignment' => 'An editor must be assigned before review is initiated. Please add editor using Participants link above.',
  'grid.reviewAttachments.title' => 'Reviewer\'s Attachments',
  'submission.productionReady' => 'Book available',
  'submission.review.uploadRevisionToRound' => 'Upload Revised File',
  'log.review.reviewerAssigned' => '{$reviewerName} has been assigned to review submission {$submissionId} for review round {$round}.',
  'submission.document' => 'Document',
  'submission.art' => 'Artwork',
  'submission.supplementary' => 'Supplementary Content',
  'submission.supplementary.creator' => 'Creator (or owner) of file',
  'submission.supplementary.subject' => 'Subject',
  'submission.supplementary.publisher' => 'Publisher',
  'submission.supplementary.sponsor' => 'Contributor or sponsoring agency',
  'grid.action.itemWorkflow' => 'Go to this submission\'s workflow',
  'notification.type.editorAssignmentProduction' => 'A production editor must be assigned before production process can be initiated. Please add production editor via the Participants link above.',
  'notification.type.editorAssignmentEditing' => 'A production editor must be assigned before editorial process is initiated. Please add production editor using Participants link above.',
  'submission.reviewForm' => 'Review Form',
  'submission.reviewFormResponse' => 'Review Form Response',
  'grid.action.createReviewFormElement' => 'Create a new review form element',
  'grid.action.editMetadata' => 'Edit Metadata',
  'submission.permissions' => 'Permissions',
  'submission.attachPermissions' => 'Attach the following permissions to the submission:',
  'submission.license' => 'License',
  'submission.copyright' => 'Copyright',
  'submission.copyrightHolder' => 'Copyright Holder',
  'submission.copyrightYear' => 'Copyright Year',
  'submission.copyrightStatement' => 'Copyright (c) {$copyrightYear} {$copyrightHolder}',
  'submission.licenseURLValid' => 'Please provide a valid remote URL (include http://).',
  'submission.licenseURL' => 'License URL',
  'submission.license.cc.by-nc-nd4' => 'CC Attribution-NonCommercial-NoDerivatives 4.0',
  'submission.license.cc.by-nc4' => 'CC Attribution-NonCommercial 4.0',
  'submission.license.cc.by-nc-sa4' => 'CC Attribution-NonCommercial-ShareAlike 4.0',
  'submission.license.cc.by-nd4' => 'CC Attribution-NoDerivatives 4.0',
  'submission.license.cc.by4' => 'CC Attribution 4.0',
  'submission.license.cc.by-sa4' => 'CC Attribution-ShareAlike 4.0',
  'submission.license.cc.by-nc-nd4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-nd/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>.</p>',
  'submission.license.cc.by-nc4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.</p>',
  'submission.license.cc.by-nc-sa4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.</p>',
  'submission.license.cc.by-nd4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by-nd/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nd/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nd/4.0/">Creative Commons Attribution-NoDerivatives 4.0 International License</a>.</p>',
  'submission.license.cc.by4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.</p>',
  'submission.license.cc.by-sa4.footer' => '<a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-sa/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.</p>',
  'submission.queries.submission' => 'Pre-Review Discussions',
  'submission.queries.review' => 'Review Discussions',
  'submission.queries.editorial' => 'Copyediting Discussions',
  'submission.queries.production' => 'Production Discussions',
  'submission.query.subject' => 'Subject',
  'submission.query.messages' => 'Messages',
  'submission.query.replies' => 'Replies',
  'submission.query.from' => 'From',
  'submission.query.lastReply' => 'Last Reply',
  'submission.query.closed' => 'Closed',
  'submission.query.addNote' => 'Add Message',
  'grid.action.openNoteForm' => 'Add a new reply to the discussion',
  'submission.query.activity' => '{$responderName} replied to {$noteTitle}: {$noteContents}',
  'submission.query.new' => '{$creatorName} started a discussion: {$noteTitle}: {$noteContents}',
  'submission.query.activity.contents' => 'There is new activity in the discussion titled "{$queryTitle}" regarding the submission "{$submissionTitle}".',
  'submission.query.new.contents' => 'You have been added to a discussion titled "{$queryTitle}" regarding the submission "{$submissionTitle}".',
); ?>