<?php return array (
  'context.current' => 'Current Journal:',
  'context.select' => 'Switch to another journal:',
  'navigation.categories' => 'Categories',
  'navigation.categories.browse' => 'Browse',
  'reviewer.article.enterReviewForm' => 'Click on icon to fill in the review form.',
  'reviewer.article.reviewFormResponse.form.responseRequired' => 'Please fill in required fields.',
  'common.openJournalSystems' => 'Open Journal Systems',
  'common.confirmComplete' => 'Are you sure you wish to mark this task as completed? You may not be able to make changes afterwards.',
  'common.payment' => 'Payment',
  'common.payments' => 'Payments',
  'common.homePageHeader.altText' => 'Homepage Header',
  'common.journalHomepageImage.altText' => 'Journal Homepage Image',
  'navigation.journalHelp' => 'Journal Help',
  'navigation.current' => 'Current',
  'navigation.otherJournals' => 'Other Journals',
  'navigation.browseByIssue' => 'By Issue',
  'navigation.browseByAuthor' => 'By Author',
  'navigation.infoForAuthors' => 'For Authors',
  'navigation.infoForLibrarians' => 'For Librarians',
  'navigation.competingInterestGuidelines' => 'Competing Interest Guidelines',
  'navigation.infoForAuthors.long' => 'Information For Authors',
  'navigation.infoForLibrarians.long' => 'Information For Librarians',
  'common.queue.long.submissionsUnassigned' => 'Unassigned',
  'common.queue.short.submissionsUnassigned' => 'Unassigned',
  'common.queue.long.submissionsInEditing' => 'Submissions in Editing',
  'common.queue.short.submissionsInEditing' => 'In Editing',
  'common.queue.long.submissionsInReview' => 'Submissions in Review',
  'common.queue.short.submissionsInReview' => 'In Review',
  'common.queue.long.submissionsArchives' => 'Archives',
  'common.queue.short.submissionsArchives' => 'Archives',
  'common.queue.long.active' => 'Active',
  'common.queue.short.active' => 'Active',
  'common.queue.long.completed' => 'Archive',
  'common.queue.short.completed' => 'Archive',
  'section.section' => 'Section',
  'section.sections' => 'Sections',
  'section.title' => 'Section title',
  'section.abbreviation' => 'Abbreviation',
  'section.abbreviation.example' => '(For example, Articles=ART)',
  'article.article' => 'Article',
  'article.articles' => 'Articles',
  'article.submissionId' => 'Submission ID',
  'article.title' => 'Title',
  'article.authors' => 'Authors',
  'article.indexingInformation' => 'Indexing Information',
  'article.metadata' => 'Metadata',
  'article.journalSection' => 'Journal Section',
  'article.file' => 'File',
  'article.suppFile' => 'Supplementary File',
  'article.suppFiles' => 'Supplementary File(s)',
  'article.suppFilesAbbrev' => 'Supp. files',
  'article.discipline' => 'Academic discipline and sub-disciplines',
  'article.subject' => 'Keywords',
  'article.coverage' => 'Coverage',
  'article.type' => 'Type, method or approach',
  'article.language' => 'Language',
  'article.sectionEditor' => 'SE',
  'article.commentsToEditor' => 'Author comments',
  'article.submission' => 'Submission',
  'article.submissions' => 'Submissions',
  'article.details' => 'Details',
  'article.abstract' => 'Abstract',
  'article.coverPage.altText' => 'Cover Image',
  'article.accessLogoOpen.altText' => 'Open Access',
  'article.accessLogoRestricted.altText' => 'Restricted Access',
  'article.comments.sectionDefault' => 'Default',
  'article.comments.disable' => 'Disable',
  'article.comments.enable' => 'Enable',
  'article.fontSize' => 'Font Size',
  'article.fontSize.small.altText' => 'Small',
  'article.fontSize.medium.altText' => 'Medium',
  'article.fontSize.large.altText' => 'Large',
  'article.return' => 'Return to Article Details',
  'submission.submissionEditing' => 'Submission Editing',
  'submission.changeSection' => 'Change to',
  'submission.sent' => 'Sent',
  'submission.editorDecision' => 'Editor Decision',
  'submission.round' => 'Round&nbsp;{$round}',
  'submission.editorReview' => 'Editor Review',
  'submission.notifyAuthor' => 'Notify Author',
  'submission.notifyEditor' => 'Notify Editor',
  'submission.editorAuthorRecord' => 'Editor/Author Email Record',
  'submission.reviewersVersion' => 'Reviewer\'s annotated version of file',
  'submission.postReviewVersion' => 'Post-review version of file',
  'submission.editorVersion' => 'Editor Version',
  'submission.authorsRevisedVersion' => 'Author\'s revised version of file',
  'submission.authorVersion' => 'Author Version',
  'submission.copyediting' => 'Copyediting',
  'submission.copyedit' => 'Copyedit',
  'submission.proofreading' => 'Proofreading',
  'submission.scheduling' => 'Scheduling',
  'submission.scheduledIn' => 'Scheduled for publication in {$issueName}.',
  'submission.scheduledIn.tba' => '(TBA)',
  'submissions.sec' => 'Sec',
  'submissions.step1' => 'Step 1',
  'submissions.step3' => 'Step 3',
  'submissions.queuedReview' => 'In Review',
  'submissions.scheduled' => 'Scheduled',
  'submissions.published' => 'Published',
  'submissions.initial' => 'Initial',
  'submissions.proofread' => 'Proofread',
  'submissions.initialProof' => 'Initial Proof',
  'submissions.postAuthor' => 'Post-Author',
  'submissions.reviewRound' => 'Review Round',
  'submissions.proof' => 'Proof',
  'submissions.editorDecision' => 'Editor Decision',
  'submissions.editorRuling' => 'Editor Ruling',
  'submission.eventLog' => 'Event Log',
  'submissions.copyeditComplete' => 'Copyedited',
  'submissions.layoutComplete' => 'Layout edited',
  'submissions.proofreadingComplete' => 'Proofread',
  'journal.currentIssue' => 'Current Issue',
  'journal.journals' => 'Journals',
  'journal.path' => 'Path',
  'context.context' => 'Journal',
  'journal.issn' => 'ISSN',
  'journal.viewAllIssues' => 'View All Issues',
  'user.noRoles.selectUsersWithoutRoles' => 'Include users with no roles in this journal.',
  'user.profile.profileImage' => 'Profile Image',
  'user.showAllJournals' => 'Show My Journals',
  'user.registerForOtherJournals' => 'Register for Other Journals',
  'user.reviewerPrompt' => 'Would you be willing to review submissions to this journal?',
  'user.reviewerPrompt.userGroup' => 'Yes, request the {$userGroup} role.',
  'user.register.contextsPrompt' => 'Which journals on this site would you like to register with?',
  'user.register.otherContextRoles' => 'Request the following roles.',
  'user.register.noContextReviewerInterests' => 'If you requested to be a reviewer on any journal, please enter your subject interests.',
  'user.myJournals' => 'My Journals',
  'user.manageMySubscriptions' => 'Manage My Subscriptions',
  'user.noRoles.chooseJournal' => 'Your account is not currently associated with any journals. Please choose a journal:',
  'user.noRoles.noRolesForJournal' => 'Your account does not currently have any roles for this journal. Please choose from the actions below:',
  'user.noRoles.submitArticle' => 'Submit a Proposal',
  'user.noRoles.submitArticleRegClosed' => 'Submit an Article: Author registration is currently disabled.',
  'user.noRoles.regReviewer' => 'Register as a Reviewer',
  'user.noRoles.regReviewerClosed' => 'Register as a Reviewer: Reviewer registration is currently disabled.',
  'user.role.manager' => 'Journal Manager',
  'user.role.sectionEditor' => 'Section Editor',
  'user.role.subscriptionManager' => 'Subscription Manager',
  'user.role.managers' => 'Journal Managers',
  'user.role.subEditors' => 'Section Editors',
  'user.role.subscriptionManagers' => 'Subscription Managers',
  'user.role.journalAssistant' => 'Journal Assistant',
  'user.role.journalAssistants' => 'Journal Assistants',
  'user.role.guestEditor' => 'Guest Editor',
  'user.role.guestEditors' => 'Guest Editors',
  'issue.issue' => 'Issue',
  'issue.issues' => 'Issues',
  'issue.title' => 'Title',
  'issue.volume' => 'Volume',
  'issue.number' => 'Number',
  'issue.vol' => 'Vol',
  'issue.no' => 'No',
  'issue.year' => 'Year',
  'issue.noIssues' => 'No Issues',
  'issue.toc' => 'Table of Contents',
  'issue.abstract' => 'Abstract',
  'issue.coverPage.altText' => 'Cover Page',
  'issue.fullIssue' => 'Full Issue',
  'issue.nonpdf.title' => 'Issue Download',
  'issue.viewIssue' => 'View Issue',
  'issue.return' => 'Return to Issue Details',
  'subscriptionTypes.currency' => 'Currency',
  'subscriptionTypes.year' => 'year',
  'subscriptionTypes.years' => 'years',
  'subscriptionTypes.month' => 'month',
  'subscriptionTypes.months' => 'months',
  'subscriptionTypes.nonExpiring' => 'Non-expiring',
  'subscriptionTypes.format' => 'Format',
  'subscriptionTypes.format.online' => 'Online',
  'subscriptionTypes.format.print' => 'Print',
  'subscriptionTypes.format.printOnline' => 'Print and Online',
  'subscriptions.inactive' => 'Inactive',
  'subscriptions.status' => 'Status',
  'subscriptions.status.active' => 'Active',
  'subscriptions.status.needsInformation' => 'Needs Information',
  'subscriptions.status.needsApproval' => 'Needs Approval',
  'subscriptions.status.awaitingManualPayment' => 'Awaiting Manual Payment',
  'subscriptions.status.awaitingOnlinePayment' => 'Awaiting Online Payment',
  'subscriptions.status.other' => 'Other, See Notes',
  'subscriptions.individualDescription' => 'Individual subscriptions require login to access subscription content.',
  'subscriptions.institutionalDescription' => 'Institutional subscriptions do not require login. The user\'s domain and/or IP address is used to provide access to subscription content.',
  'subscriptions.institutionalOnlinePaymentDescription' => '<strong>Note:</strong> Institutional subscriptions purchased online require approval of the domain and IP ranges before the subscription is activated.',
  'submission.event.general.defaultEvent' => 'Submission event',
  'submission.event.submissionSubmitted' => 'Article submitted',
  'submission.event.general.issueScheduled' => 'Submission sent to issue scheduling queue',
  'submission.event.general.issueAssigned' => 'Submission assigned to issue',
  'submission.event.general.articlePublished' => 'Article published',
  'submission.event.author.authorRevision' => 'Author revision submitted',
  'submission.event.general.authorRevision' => 'Author revision file updated',
  'submission.event.editor.editorAssigned' => 'Editor assigned to submission',
  'submission.event.editor.editorUnassigned' => 'Editor unassigned from submission',
  'submission.event.editor.editorDecision' => 'Editor decision submitted',
  'submission.event.editor.editorFile' => 'Editor file updated',
  'submission.event.editor.submissionArchived' => 'Submission sent to archive',
  'submission.event.editor.submissionRestored' => 'Submission restored from archive',
  'submission.event.copyedit.copyeditorAssigned' => 'Copyeditor assigned to submission',
  'submission.event.copyedit.copyeditorUnassigned' => 'Copyeditor unassigned from submission',
  'submission.event.copyedit.copyeditInitiated' => 'Copyedit assignment initiated',
  'submission.event.copyedit.copyeditRevision' => 'Copyeditor revisions file updated',
  'submission.event.copyedit.copyeditInitialCompleted' => 'Initial copyedit completed',
  'submission.event.copyedit.copyeditFinalCompleted' => 'Final copyedit completed',
  'submission.event.copyedit.copyeditSetFile' => 'Copyedit file updated',
  'submission.event.proofread.proofreaderAssigned' => 'Proofreader assigned to submission',
  'submission.event.proofread.proofreaderUnassigned' => 'Proofreader unassigned from submission',
  'submission.event.proofread.proofreadInitiated' => 'Proofread assignment initiated',
  'submission.event.proofread.proofreadRevision' => 'Proofreader revisions file updated',
  'submission.event.proofread.proofreadCompleted' => 'Proofread assignment completed',
  'submission.event.layout.layoutEditorAssigned' => 'Layout editor assigned to submission',
  'submission.event.layout.layoutEditorUnassigned' => 'Layout editor unassigned from submission',
  'submission.event.layout.layoutInitiated' => 'Layout assignment initiated',
  'submission.event.layout.layoutGalleyCreated' => 'Layout galley updated',
  'submission.event.layout.layoutComplete' => 'Layout assignment completed',
  'reader.subscribersOnly' => 'Subscribers Only',
  'reader.subscriptionRequiredLoginText' => 'Subscription required to access item. To verify subscription, log in to journal.',
  'reader.openAccess' => 'Open Access',
  'reader.subscriptionAccess' => 'Requires Subscription',
  'reader.subscriptionOrFeeAccess' => 'Requires Subscription or Fee',
  'comments.commentsOnArticle' => 'Comments on this article',
  'comments.authenticated' => 'by <a href="{$publicProfileUrl}" target="_parent">{$userName}</a>',
  'search.results.orderBy' => 'Order results by',
  'search.results.orderBy.article' => 'Article Title',
  'search.results.orderBy.author' => 'Author',
  'search.results.orderBy.date' => 'Publication Date',
  'search.results.orderBy.issue' => 'Issue',
  'search.results.orderBy.journal' => 'Journal Title',
  'search.results.orderBy.popularityAll' => 'Popularity (All Time)',
  'search.results.orderBy.popularityMonth' => 'Popularity (Last Month)',
  'search.results.orderBy.relevance' => 'Relevance',
  'search.results.orderDir.asc' => 'Ascending',
  'search.results.orderDir.desc' => 'Descending',
  'search.results.similarDocuments' => 'similar documents',
  'admin.settings.oaiRegistrationDescription' => 'To have the contents of all journals hosted on this site indexed within a globally distributed system of research databases, <a href="http://pkp.sfu.ca/harvester/add.php" target="_blank">register</a> your site\'s URL with the Public Knowledge Project metadata <a href="http://pkp.sfu.ca/harvester/" target="_blank">harvester</a>. This tool collects the metadata from each indexed item in this journal, enabling accurate and collective searching among the research sites that adhere to the <a href="http://www.openarchives.org/OAI/openarchivesprotocol.htm#Introduction" target="_blank">Open Archives Initiative Protocol for Metadata Harvesting</a>.
<br /><br />
<a href="http://pkp.sfu.ca/harvester/add.php" target="_blank">Click here</a> and enter <span class="highlight">{$siteUrl}</span> under <strong>Site URL</strong>, and <span class="highlight">{$oaiUrl}</span> under <strong>Base URL for OAI Archive</strong>.
<br /><br />
Note that the OAI interface can be disabled for this site by editing the OJS system configuration. Future versions of OJS will allow the OAI interface to be enabled or disabled for individual journals within the site.',
  'admin.auth.defaultSourceDescription' => '<p>Specifying a default authentication source other than OJS has the following effects:</p>
<ul>
	<li>If a user attempts to register a new account with this site with a username that exists on the authentication source (but not in the OJS database), the registration attempt is only allowed if the supplied password is valid for that user account.</li>
</ul>',
  'admin.overwriteConfigFileInstructions' => '<h4>NOTE!</div>
<p>The system could not automatically overwrite the configuration file. To apply your configuration changes you must open <tt>config.inc.php</tt> in a suitable text editor and replace its contents with the contents of the text field below.</p>',
  'subscriptionManager.subscriptionManagement' => 'Subscription Management',
  'subscriptionManager.individualSubscriptions' => 'Individual Subscriptions',
  'subscriptionManager.institutionalSubscriptions' => 'Institutional Subscriptions',
  'subscriptionManager.subscriptionTypes' => 'Subscription Types',
  'plugins.categories.viewableFiles' => 'Article Galley Plugins',
  'plugins.categories.viewableFiles.description' => 'Article Galley Plugins add support for displaying different document types as article galleys.',
  'plugins.categories.auth.description' => 'Authorization Plugins allow Open Journal Systems to delegate user authentication tasks to other systems, such as LDAP servers.',
  'plugins.categories.citationFormats.description' => 'Citation format plugins provide users with various formats in which to access article citations.',
  'plugins.categories.generic.description' => 'Generic plugins are used to extend Open Journal Systems in a variety of ways that are not supported by the other plugin categories.',
  'manager.setup.lockssDescription' => 'Open Journal Systems supports the <a href="http://www.lockss.org/" target="_blank">LOCKSS</a> (Lots of Copies Keep Stuff Safe) system to ensure a secure and permanent archive for the journal. LOCKSS is open source software developed at Stanford University Library that enables libraries to preserve selected web journals by regularly polling registered journal websites for newly published content and archiving it. Each archive is continually validated against other library caches, and if content is found to be corrupted or lost, the other caches or the journal is used to restore it.
<br /><br />
Setting up LOCKSS support for Open Journal Systems does not need to take place until after publishing is fully underway, at which point follow these two steps:',
  'manager.setup.clockssDescription' => 'Open Journal Systems also supports the <a href="http://clockss.org/" target="_blank">CLOCKSS</a> (Controlled Lots of Copies Keep Stuff Safe) system to ensure a secure and permanent archive for the journal. CLOCKSS is based upon the open source LOCKSS software developed at Stanford University Library that enables libraries to preserve selected web journals by regularly polling registered journal websites for newly published content and archiving it. Each archive is continually validated against other library caches, and if content is found to be corrupted or lost, the other caches or the journal is used to restore it.
<br /><br />
Setting up CLOCKSS support for Open Journal Systems does not need to take place until after publishing is fully underway.',
  'manager.setup.authorCopyrightNotice.sample' => '<h3>Proposed Creative Commons Copyright Notices</h3>
<h4>1. Proposed Policy for Journals That Offer Open Access</h4>
Authors who publish with this journal agree to the following terms:
<ol type="a">
	<li>Authors retain copyright and grant the journal right of first publication with the work simultaneously licensed under a <a target="_new" href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution License</a> that allows others to share the work with an acknowledgement of the work\'s authorship and initial publication in this journal.</li>
	<li>Authors are able to enter into separate, additional contractual arrangements for the non-exclusive distribution of the journal\'s published version of the work (e.g., post it to an institutional repository or publish it in a book), with an acknowledgement of its initial publication in this journal.</li>
	<li>Authors are permitted and encouraged to post their work online (e.g., in institutional repositories or on their website) prior to and during the submission process, as it can lead to productive exchanges, as well as earlier and greater citation of published work (See <a target="_new" href="http://opcit.eprints.org/oacitation-biblio.html">The Effect of Open Access</a>).</li>
</ol>

<h4>Proposed Policy for Journals That Offer Delayed Open Access</h4>
Authors who publish with this journal agree to the following terms:
<ol type="a">
	<li>Authors retain copyright and grant the journal right of first publication, with the work [SPECIFY PERIOD OF TIME] after publication simultaneously licensed under a <a target="_new" href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution License</a> that allows others to share the work with an acknowledgement of the work\'s authorship and initial publication in this journal.</li>
	 <li>Authors are able to enter into separate, additional contractual arrangements for the non-exclusive distribution of the journal\'s published version of the work (e.g., post it to an institutional repository or publish it in a book), with an acknowledgement of its initial publication in this journal.</li>
	 <li>Authors are permitted and encouraged to post their work online (e.g., in institutional repositories or on their website) prior to and during the submission process, as it can lead to productive exchanges, as well as earlier and greater citation of published work (See <a target="_new" href="http://opcit.eprints.org/oacitation-biblio.html"> The Effect of Open Access</a>).</li>
</ol>',
  'manager.setup.citations.enable' => 'Enable the Citation Markup Assistant',
  'manager.setup.basicEditorialStepsDescription' => 'Steps: Submission Queue &gt; Submission Review &gt; Submission Editing &gt; Table of Contents.<br /><br />
Select a model for handling these aspects of the editorial process. (To designate a Managing Editor and Section Editors, go to Editors in Journal Management.)',
  'manager.setup.referenceLinkingDescription' => '<p>To enable readers to locate online versions of the work cited by an author, the following options are available.</p>

<ol>
	<li><strong>Add a Reading Tool</strong><p>The Journal Manager can add "Find References" to the Reading Tools that accompany published items, which enables readers to paste a reference\'s title and then search pre-selected scholarly databases for the cited work.</p></li>
	<li><strong>Embed Links in the References</strong><p>The Layout Editor can add a link to references that can be found online by using the following instructions (which can be edited).</p></li>
</ol>',
  'manager.people.confirmDisable' => 'Disable this user? This will prevent the user from logging into the system.

You may optionally provide the user with a reason for disabling their account.',
  'manager.people.noAdministrativeRights' => 'Sorry, you do not have administrative rights over this user. This may be because:
		<ul>
			<li>The user is a site administrator</li>
			<li>The user is active in journals you do not manage</li>
		</ul>
	This task must be performed by a site administrator.',
  'editor.submissionReview.notes' => '<ol>
	<li>Highlighted items indicate action is required by an editor, labelled as follows:
		<ul>
			<li class="highlightReviewerNotNotified">A Reviewer has been assigned but not notified by email</li>
			<li class="highlightNoDecision">All Reviewers have returned with their comments, but no decision is recorded</li>
			<li class="highlightRevisedCopyUploaded">Author has uploaded a revised manuscript</li>
			<li class="highlightReviewerConfirmationOverdue">Reviewer is overdue to confirm peer review invitation</li>
			<li class="highlightReviewerCompletionOverdue">Reviewer is overdue to complete review</li>
		</ul>
	</li>
	<li>"Due" is filled in when reviewer accepts request to review; it displays number of weeks to review\'s due date or (-) weeks that it is overdue.</li>
</ol>',
  'editor.submissionEditing.notes' => '<ol>
	<li>Highlighted items indicate action is required by an editor, labelled as follows:
		<ul>
			<li class="highlightCopyediting">An action is required in the copyediting stage</li>
			<li class="highlightLayoutEditing">An action is required in the layout editing stage</li>
			<li class="higlightProofreading">An action is required in the proofreading stage</li>
		</ul>
	</li>
</ol>',
  'editor.article.selectReviewerNotes' => 'Name links to reviewer\'s profile.<br/>
Ratings is out of 5 (Excellent).<br/>
Weeks refers to average period of time to complete a review.<br/>
Latest is date of most recently accepted review.<br/>
Active is how many reviews are currently being considered or underway.',
  'sectionEditor.activeEditorialAssignments' => 'Active Editorial Assignments',
  'sectionEditor.completedEditorialAssignments' => 'Completed Editorial Assignments',
  'sectionEditor.noneAssigned' => 'No submissions assigned.',
  'sectionEditor.copyedit.confirmRenotify' => 'Notifying this copy editor again will restart their assignment. Are you sure you wish to do this?',
  'sectionEditor.author.confirmRenotify' => 'Notifying this author again will restart their assignment. Are you sure you wish to do this?',
  'sectionEditor.layout.confirmRenotify' => 'Notifying this layout editor again will restart their assignment. Are you sure you wish to do this?',
  'sectionEditor.proofreader.confirmRenotify' => 'Notifying this proofreader again will restart their assignment. Are you sure you wish to do this?',
  'sectionEditor.regrets.breadcrumb' => 'Regrets',
  'sectionEditor.regrets.title' => '#{$submissionId} Reviewer Regrets, Cancellations & Earlier Rounds',
  'sectionEditor.regrets' => 'Regrets',
  'sectionEditor.regrets.link' => 'View Regrets, Cancels, Previous Rounds',
  'sectionEditor.regrets.reviewRound' => 'Peer Review, Round {$round}',
  'sectionEditor.regrets.decisionRound' => 'Editor Decision, Round {$round}',
  'sectionEditor.regrets.regretsAndCancels' => 'Reviewer Regrets & Cancellations',
  'sectionEditor.regrets.regret' => 'Regret',
  'sectionEditor.regrets.result' => 'Result',
  'sectionEditor.review.enrollReviewer' => 'Enroll an Existing User As Reviewer',
  'sectionEditor.review.createReviewer' => 'Create New Reviewer',
  'layoutEditor.activeEditorialAssignments' => 'Active Editorial Assignments',
  'layoutEditor.completedEditorialAssignments' => 'Completed Editorial Assignments',
  'layoutEditor.noActiveAssignments' => 'No active editorial assignments.',
  'layoutEditor.layoutEditingAssignments' => 'Layout Editing Assignments',
  'layoutEditor.galley.uploadGalleyFormat' => 'Upload galley format',
  'layoutEditor.galley.replaceGalley' => 'Replace File',
  'layoutEditor.galley.uploadSuppFile' => 'Upload supplementary file',
  'submission.layout.imageInvalid' => 'Invalid image format. Accepted formats are .gif, .jpg, and .png.',
  'submission.layout.galley.remotelyHostedContent' => 'This galley will be available at a separate website.',
  'submission.layout.galley.remoteURL' => 'URL of remotely-hosted content',
  'reviewer.pendingReviews' => 'Articles Pending Review',
  'reviewer.completedReviews' => 'Done',
  'reviewer.averageQuality' => 'Rating',
  'reviewer.article.fileToBeReviewed' => 'File to be reviewed',
  'reviewer.article.notifyTheEditor' => 'Notify The Editor',
  'reviewer.article.canDoReview' => 'Will do the review',
  'reviewer.article.cannotDoReview' => 'Unable to do the review',
  'reviewer.article.restrictedFileAccess' => 'Submission will be made available, if and when reviewer agrees to undertake review',
  'reviewer.article.submissionEditor' => 'Submission Editor',
  'reviewer.article.reviewerCommentsDescription' => 'Type or paste in review comments here',
  'reviewer.article.editorToEnter' => 'Editor To Enter',
  'reviewer.article.sendReminder' => 'Send Reminder',
  'reviewer.article.automatic' => '(Auto)',
  'reviewer.article.recommendation' => 'Recommendation',
  'reviewer.article.submitReview' => 'Submit Review To Editor',
  'reviewer.article.reviewerComments' => 'Comments',
  'reviewer.article.uploadedFile' => 'Uploaded files',
  'reviewer.article.reviewersAnnotatedVersion' => 'Version uploaded by reviewer',
  'reviewer.article.reviewersAnnotatedVersionDescription' => '(If you want to annotate the file, for the editor, save on your hard drive and use Browse/Upload.)',
  'reviewer.article.schedule.request' => 'Editor\'s Request',
  'reviewer.article.schedule.response' => 'Your Response',
  'reviewer.article.schedule.submitted' => 'Review Submitted',
  'reviewer.article.schedule.due' => 'Review Due',
  'reviewer.article.decision.accept' => 'Accept Submission',
  'reviewer.article.decision.pendingRevisions' => 'Revisions Required',
  'reviewer.article.decision.resubmitHere' => 'Resubmit for Review',
  'reviewer.article.decision.resubmitElsewhere' => 'Resubmit Elsewhere',
  'reviewer.article.decision.decline' => 'Decline Submission',
  'reviewer.article.decision.seeComments' => 'See Comments',
  'reviewer.article.schedule' => 'Schedule',
  'reviewer.article.submissionToBeReviewed' => 'Submission To Be Reviewed',
  'reviewer.article.reviewSchedule' => 'Review Schedule',
  'reviewer.article.reviewSteps' => 'Review Steps',
  'reviewer.article.reviewerGuidelines' => 'Reviewer Guidelines',
  'reviewer.article.reviewGuidelinesDescription' => 'The Review Guidelines will provide reviewers with criteria for judging a submission\'s suitability for publication in the journal, and can include any special instructions for preparing an effective and helpful review. In conducting the review, reviewers are presented with with two open text boxes, the first "for author and editor," and the second "for editor." Alternatively, the Journal Manager can create a peer review form under Review Forms. In all cases, editors will have the option of including the reviews in corresponding with the author.',
  'reviewer.article.notifyEditorA' => 'Notify the submission\'s editor',
  'reviewer.article.notifyEditorB' => 'as to whether you will undertake the review.',
  'reviewer.article.consultGuidelines' => 'If you are going to do the review, consult Reviewer Guidelines below.',
  'reviewer.article.downloadSubmission' => 'Click on file names to download and review (on screen or by printing) the files associated with this submission.',
  'reviewer.article.enterCompetingInterests' => 'Declare whether or not you have competing interests with regard to this research (see <a target="_new" class="action" href="{$competingInterestGuidelinesUrl}">CI&nbsp;Policy</a>).',
  'reviewer.competingInterests' => 'Competing Interests',
  'reviewer.article.enterReviewA' => 'Click on icon to enter (or paste) your review of this submission.',
  'reviewer.article.uploadFile' => 'In addition, you can upload files for the editor and/or author to consult.',
  'reviewer.article.selectRecommendation' => 'Select a recommendation and submit the review to complete the process. You must enter a review or upload a file before selecting a recommendation.',
  'reviewer.article.selectRecommendation.byEditor' => 'Set or adjust the reviewer recommendation.',
  'reviewer.article.mustSelectDecision' => 'No recommendation was selected. You must choose a recommendation to submit.',
  'reviewer.article.confirmDecision' => 'Once you have recorded a decision you will no longer be able to make changes to this review. Are you sure you wish to continue?',
  'reviewer.article.ensuringBlindReview' => 'Ensuring a Blind Review',
  'copyeditor.article.fileToCopyedit' => 'File To C/E',
  'copyeditor.article.copyeditorFile' => 'Copyeditor File',
  'copyeditor.article.uploadedFile' => 'Uploaded File',
  'copyeditor.article.copyeditorFinalFile' => 'Copyeditor File',
  'proofreader.noProofreadingAssignments' => 'No Proofreading Assignments',
  'author.submit.uploadInstructions' => '<p>To upload a manuscript to this journal, complete the following steps.</p>
<ol>
<li>On this page, click Browse (or Choose File) which opens a Choose File window for locating the file on the hard drive of your computer.</li>
<li>Locate the file you wish to submit and highlight it.</li>
<li>Click Open on the Choose File window, which places the name of the file on this page.</li>
<li>Click Upload on this page, which uploads the file from the computer to the journal\'s web site and renames it following the journal\'s conventions.</li>
<li>Once the submission is uploaded, click Save and Continue at the bottom of this page.</li>
</ol>',
  'submission.review.mustUploadFileForReview' => 'Request email cannot be sent until a Review Version is in place.',
  'submission.copyedit.mustUploadFileForInitialCopyedit' => 'Request email cannot be sent until file is selected for copyediting in Editor Decision, Review page.',
  'submission.copyedit.mustUploadFileForCopyedit' => 'Request email cannot be sent until file is uploaded for copyediting.',
  'submission.copyedit.initialCopyedit' => 'Initial Copyedit',
  'submission.copyedit.editorsCopyedit' => 'Editor\'s Copyedit',
  'submission.copyedit.editorAuthorReview' => 'Author Copyedit',
  'submission.copyedit.finalCopyedit' => 'Final Copyedit',
  'submission.copyedit.copyeditVersion' => 'C/E Version',
  'submission.copyedit.selectCopyeditor' => 'Assign Copyeditor',
  'submission.copyedit.useFile' => 'Use File',
  'submission.copyedit.copyeditComments' => 'Copyedit Comments',
  'submission.copyedit.instructions' => 'Copyedit Instructions',
  'submission.layout.noLayoutFile' => 'None (Upload final copyedit version as Layout Version prior to sending request)',
  'submission.layout.publicGalleyId' => 'Public Galley Identifier',
  'submission.layout.galleyPublicIdentificationExists' => 'Public galley identification already exists.',
  'submission.layout.assignLayoutEditor' => 'Assign Layout Editor',
  'submission.layout.replaceLayoutEditor' => 'Replace Layout Editor',
  'submission.layout.layoutComments' => 'Layout Comments',
  'submission.layout.instructions' => 'Layout Instructions',
  'submission.layout.referenceLinking' => 'Reference Linking',
  'submission.proofreadingComments' => 'Proofreading Comments',
  'submission.proofread.corrections' => 'Proofreading Corrections',
  'submission.proofread.instructions' => 'Proofing Instructions',
  'submission.logType.article' => 'Article',
  'submission.logType.author' => 'Author',
  'submission.logType.editor' => 'Editor',
  'submission.logType.review' => 'Review',
  'submission.logType.copyedit' => 'Copyedit',
  'submission.logType.layout' => 'Layout',
  'submission.logType.proofread' => 'Proofread',
  'submission.comments.editorAuthorCorrespondence' => 'Editor/Author Correspondence',
  'submission.comments.copyeditComments' => 'Copyedit Comments',
  'submission.comments.viewableDescription' => 'These comments can be shared with the author.<br />
(After saving, further comments can be added.)',
  'submission.comments.canShareWithAuthor' => 'For author and editor',
  'submission.comments.cannotShareWithAuthor' => 'For editor',
  'submission.comments.blindCcReviewers' => 'After sending, present an editable BCC copy to send to reviewers.',
  'submission.comments.forAuthorEditor' => 'For author and editor',
  'submission.comments.forEditor' => 'For editor',
  'submission.comments.saveAndEmailAuthor' => 'Save and Email Author',
  'submission.comments.saveAndEmailEditor' => 'Save and Email Editor',
  'user.register.selectContext' => 'Select a journal to register with:',
  'user.register.noJournals' => 'There are no journals you may register with on this site.',
  'user.register.privacyStatement' => 'Privacy Statement',
  'user.register.registrationDisabled' => 'This journal is currently not accepting user registrations.',
  'user.register.form.passwordLengthTooShort' => 'The password you entered is not long enough.',
  'user.register.readerDescription' => 'Notified by email on publication of an issue of the journal.',
  'user.register.openAccessNotificationDescription' => 'Notified by email when an issue of the journal is made open access.',
  'user.register.authorDescription' => 'Able to submit items to the journal.',
  'user.register.reviewerDescriptionNoInterests' => 'Willing to conduct peer review of submissions to the journal.',
  'user.register.reviewerDescription' => 'Willing to conduct peer review of submissions to the site.',
  'user.register.reviewerInterests' => 'Identify reviewing interests (substantive areas and research methods):',
  'user.subscriptions.mySubscriptions' => 'My Subscriptions',
  'user.subscriptions.subscriptionStatus' => 'Subscription Status',
  'user.subscriptions.statusInformation' => 'Active and expired subscriptions are displayed below along with their expiration date. In addition, the following status information may be included with each subscription.',
  'user.subscriptions.status' => 'Status',
  'user.subscriptions.statusDescription' => 'Description',
  'user.subscriptions.status.needsInformationDescription' => 'Additional information is needed before the subscription can be activated',
  'user.subscriptions.status.needsApprovalDescription' => 'Subscription must be reviewed before it can be activated',
  'user.subscriptions.status.awaitingManualPaymentDescription' => 'Manual payment has been initiated but not yet received',
  'user.subscriptions.status.awaitingOnlinePaymentDescription' => 'An online payment has been initiated but canceled or not completed',
  'user.subscriptions.individualSubscriptions' => 'Individual Subscription',
  'user.subscriptions.institutionalSubscriptions' => 'Institutional Subscriptions',
  'user.subscriptions.renew' => 'Renew',
  'user.subscriptions.purchase' => 'Purchase',
  'user.subscriptions.purchaseNewSubscription' => 'Purchase New Subscription',
  'user.subscriptions.purchaseIndividualSubscription' => 'Purchase Individual Subscription',
  'user.subscriptions.purchaseInstitutionalSubscription' => 'Purchase Institutional Subscription',
  'user.subscriptions.expires' => 'Expires',
  'user.subscriptions.expired' => 'Expired',
  'user.subscriptions.viewSubscriptionTypes' => 'View Available Subscription Types',
  'user.subscriptions.form.typeId' => 'Subscription Type',
  'user.subscriptions.form.membership' => 'Membership',
  'user.subscriptions.form.membershipRequired' => 'The selected subscription type requires membership information.',
  'user.subscriptions.form.typeIdValid' => 'Please select a valid subscription type.',
  'user.subscriptions.form.subscriptionExists' => 'This user account already has an individual subscription.',
  'user.subscriptions.form.membershipInstructions' => 'Membership information if required for the selected subscription type.',
  'user.subscriptions.form.institutionName' => 'Institution name',
  'user.subscriptions.form.institutionNameRequired' => 'An institution name is required.',
  'user.subscriptions.form.institutionMailingAddress' => 'Mailing address',
  'user.subscriptions.form.domain' => 'Domain',
  'user.subscriptions.form.domainInstructions' => 'If a domain is entered here, IP ranges are optional.<br />Valid values are domain names (e.g. lib.sfu.ca).',
  'user.subscriptions.form.domainIPRangeRequired' => 'The selected subscription type requires a domain and/or an IP range for subscription authentication.',
  'user.subscriptions.form.domainValid' => 'Please enter a valid domain.',
  'user.subscriptions.form.ipRange' => 'IP ranges',
  'user.subscriptions.form.ipRangeItem' => '&#8226;',
  'user.subscriptions.form.ipRangeInstructions' => 'If IP ranges are entered here, the domain is optional.<br />Valid values include an IP address (e.g. 142.58.103.1), IP range (e.g. 142.58.103.1 - 142.58.103.4), IP range with wildcard \'*\' (e.g. 142.58.*.*), and an IP range with CIDR (e.g. 142.58.100.0/24).',
  'user.subscriptions.form.ipRangeValid' => 'Please enter a valid IP range.',
  'user.subscriptions.form.deleteIpRange' => 'Delete',
  'user.subscriptions.form.addIpRange' => 'Add',
  'search.browseAuthorIndex' => 'Browse Author Index',
  'search.searchFor' => 'Search articles for',
  'search.withinJournal' => 'Within',
  'search.allJournals' => 'All Journals',
  'search.authorIndex' => 'Browse Author Index',
  'search.authorDetails' => 'Author Details',
  'search.syntaxInstructions' => 'Search tips: <ul>
<li>Search terms are case-insensitive</li>
<li>Common words are ignored</li>
<li>By default only articles containing <em>all</em> terms in the query are returned (i.e., <em>AND</em> is implied)</li>
<li>Combine multiple words with <em>OR</em> to find articles containing either term; e.g., <em>education OR research</em></li>
<li>Use parentheses to create more complex queries; e.g., <em>archive ((journal OR conference) NOT theses)</em></li>
<li>Search for an exact phrase by putting it in quotes; e.g., <em>"open access publishing"</em></li>
<li>Exclude a word by prefixing it with <strong>-</strong> or <em>NOT</em>; e.g. <em>online -politics</em> or <em>online NOT politics</em></li>
<li>Use <strong>*</strong> in a term as a wildcard to match any sequence of characters; e.g., <em>soci* morality</em> would match documents containing "sociological" or "societal"</li>
</ul>',
  'article.pageTitle' => 'View of {$title}',
  'article.pdf.title' => 'Portable Document Format (PDF)',
  'article.download' => 'Download this PDF file',
  'article.pluginMissing' => '<p>The PDF file you selected should load here if your Web browser has a PDF reader plug-in installed (for example, a recent version of <a href="https://get.adobe.com/reader/">Adobe Acrobat Reader</a>).</p>',
  'article.nonpdf.title' => 'Article Download',
  'article.nonpdf.note' => 'The file you selected should begin downloading automatically. If it does not, click the link below. Note that this file may require a special viewer or plugin to view.<br /><br />If the file does not download automatically, <a href="{$url}">click here</a>.',
  'site.journalsHosted' => 'Journals hosted on this site',
  'site.journalView' => 'View Journal',
  'site.journalRegister' => 'Register',
  'site.journalCurrent' => 'Current Issue',
  'site.noJournals' => 'There are no journals available.',
  'current.current' => 'Current',
  'current.noCurrentIssue' => 'No Current Issue',
  'current.noCurrentIssueDesc' => 'This journal has not published any issues.',
  'archive.archives' => 'Archives',
  'archive.archivesPageNumber' => 'Archives - Page {$pageNumber}',
  'archive.browse' => 'Browse through the older issues',
  'archive.issueUnavailable' => 'Issue Unavailable',
  'about.statistics' => 'Statistics',
  'about.contact' => 'Contact',
  'about.aboutContext' => 'About the Journal',
  'about.history' => 'Journal History',
  'about.editorialTeam' => 'Editorial Team',
  'about.editorialTeam.biography' => 'Biography',
  'about.editorialPolicies' => 'Editorial Policies',
  'about.focusAndScope' => 'Focus and Scope',
  'about.sectionPolicies' => 'Section Policies',
  'about.submissions' => 'Submissions',
  'about.onlineSubmissions.login' => 'Login',
  'about.onlineSubmissions.register' => 'Register',
  'about.onlineSubmissions.registrationRequired' => '{$login} or {$register} to make a submission.',
  'about.onlineSubmissions.submissionActions' => '{$newSubmission} or {$viewSubmissions}.',
  'about.onlineSubmissions.newSubmission' => 'Make a new submission',
  'about.onlineSubmissions.viewSubmissions' => 'view your pending submissions',
  'about.authorGuidelines' => 'Author Guidelines',
  'about.submissionPreparationChecklist' => 'Submission Preparation Checklist',
  'about.submissionPreparationChecklist.description' => 'As part of the submission process, authors are required to check off their submission\'s compliance with all of the following items, and submissions may be returned to authors that do not adhere to these guidelines.',
  'about.copyrightNotice' => 'Copyright Notice',
  'about.privacyStatement' => 'Privacy Statement',
  'about.authorFees' => 'Author Fees',
  'about.authorFeesMessage' => 'This journal charges the following author fees.',
  'about.peerReviewProcess' => 'Peer Review Process',
  'about.publicationFrequency' => 'Publication Frequency',
  'about.openAccessPolicy' => 'Open Access Policy',
  'about.delayedOpenAccess' => 'Delayed Open Access',
  'about.delayedOpenAccessDescription1' => 'The contents of this journal will be available in an open access format',
  'about.delayedOpenAccessDescription2' => 'month(s) after an issue is published.',
  'about.authorSelfArchive' => 'Author Self-Archiving',
  'about.archiving' => 'Archiving',
  'about.subscriptions' => 'Subscriptions',
  'about.subscriptions.individual' => 'Individual Subscriptions',
  'about.subscriptions.institutional' => 'Institutional Subscriptions',
  'about.subscriptionsContact' => 'Subscriptions Contact',
  'about.subscriptionTypes.name' => 'Name',
  'about.subscriptionTypes.format' => 'Format',
  'about.subscriptionTypes.duration' => 'Duration',
  'about.subscriptionTypes.cost' => 'Cost',
  'about.availableSubscriptionTypes' => 'Subscription Types',
  'about.memberships' => 'Memberships',
  'about.aboutThisPublishingSystem' => 'About this Publishing System',
  'about.aboutThisPublishingSystem.altText' => 'OJS Editorial and Publishing Process',
  'about.aboutOJSJournal' => 'This journal uses Open Journal Systems {$ojsVersion}, which is open source journal management and publishing software developed, supported, and freely distributed by the <a href="http://pkp.sfu.ca/">Public Knowledge Project</a> under the GNU General Public License.',
  'about.aboutOJSSite' => 'This site uses Open Journal Systems {$ojsVersion}, which is open source journal management and publishing software developed, supported, and freely distributed by the <a href="http://pkp.sfu.ca/">Public Knowledge Project</a> under the GNU General Public License.',
  'help.ojsHelp' => 'Open Journal Systems Help',
  'help.ojsHelpAbbrev' => 'OJS Help',
  'help.searchReturnResults' => 'Return to Search Results',
  'help.goToEditPage' => 'Edit {$sectionTitle}',
  'donations.thankYou' => 'Thank You',
  'donations.thankYouMessage' => 'Thank you for making a contribution.  Your contribution is much appreciated.',
  'gifts.buyer' => 'From',
  'gifts.buyerDescription' => 'Who is this gift from?',
  'gifts.recipient' => 'To',
  'gifts.recipientDescription' => 'Who is this gift to?',
  'gifts.thankYou' => 'Thank You',
  'gifts.thankYouMessage' => 'Your gift purchase has been completed. You will receive a copy of the gift email sent to the recipient once your payment has been processed.',
  'gifts.purchaseGiftIndividualSubscription' => 'Gift Subscription',
  'gifts.subscriptionFormIntroduction' => 'Please fill out the form below. The provided contact information, along with your gift note, will be used to email the recipient and inform them of their new gift subscription (you will also receive a copy of this email).',
  'gifts.details' => 'Gift Details',
  'gifts.detailsDescription' => 'Please select the gift below and include a personalized message that will be emailed to the recipient (you will receive a copy of this email).',
  'gifts.gift' => 'Gift',
  'gifts.noteTitle' => 'Title',
  'gifts.note' => 'Gift Note',
  'gifts.noteTitleRequired' => 'Please provide a title for your personalized message.',
  'gifts.noteRequired' => 'Please provide a personalized message.',
  'gifts.localeRequired' => 'Please select a language for your personalized message.',
  'gifts.myGifts' => 'My Gifts',
  'gifts.manageMyGifts' => 'Manage My Gifts',
  'gifts.redeemGift' => 'Redeem Gift',
  'gifts.status.notRedeemed' => 'Available',
  'gifts.status.redeemed' => 'Redeemed',
  'gifts.status.redeemGift' => 'Redeem Gift',
  'gifts.subscriptions' => 'Subscriptions',
  'gifts.subscriptionsDescription' => 'A gift subscription redeemed here will replace your existing subscription (if you have one). Subscriptions will begin on the redemption date and will be valid for the duration of the subscription type.',
  'gifts.purchaseGiftSubscription' => 'Give a gift subscription',
  'gifts.giftSubscriptionsAvailable' => 'Gift subscriptions are also available. Gift subscriptions can be redeemed at any time by the recipient and are a great way to support this journal.',
  'gifts.noSubscriptions' => 'No gift subscriptions',
  'gifts.giftRedeemed' => 'The gift was successfully redeemed.',
  'gifts.noGiftToRedeem' => 'This gift is not available to be redeemed.',
  'gifts.giftAlreadyRedeemed' => 'This gift has already been redeemed.',
  'gifts.giftNotValid' => 'This gift is not valid and could not be redeemed.',
  'gifts.subscriptionTypeNotValid' => 'The subscription type for this gift is not valid. Please contact the subscription manager.',
  'gifts.subscriptionNonExpiring' => 'The gift was not redeemed since you already have a non-expiring subscription with this journal.',
  'payment.loginRequired' => 'You must be logged in to make a payment.',
  'payment.loginRequired.forArticle' => 'Subscription or article purchase required to access item. To verify subscription, access previous purchase, or purchase article, log in to journal.',
  'payment.loginRequired.forIssue' => 'Subscription or issue purchase required to access item. To verify subscription, access previous purchase, or purchase issue, log in to journal.',
  'payment.loginRequired.forDonation' => 'You must be logged in to make a donation.',
  'payment.paid' => 'Paid',
  'payment.payNow' => 'Pay Now',
  'payment.waive' => 'Waive',
  'payment.alreadyPaid' => 'Already Paid',
  'payment.alreadyPaidMessage' => 'Select this box if you\'ve already sent your payment to the journal in order to finish the submission process.  The submission will not be reviewed until the payment arrives.  Click PAY NOW above to see the payment instructions.',
  'payment.paymentReceived' => 'Payment Received',
  'payment.paymentSent' => 'Payment has already been sent',
  'payment.authorFees' => 'Author Fees',
  'payment.type.submission' => 'Submission Fee',
  'payment.type.publication' => 'Publication Fee',
  'payment.type.fastTrack' => 'Fast Track Review Fee',
  'payment.type.membership' => 'Individual Membership Fee',
  'payment.type.purchaseArticle' => 'Purchase Article Fee',
  'payment.type.purchaseIssue' => 'Purchase Issue Fee',
  'payment.type.subscription' => 'Subscription Fee',
  'payment.type.donation' => 'Donations',
  'payment.type.gift' => 'Gift',
  'payment.type.gift.subscription' => 'Subscription',
  'payment.donation.makeDonation' => 'Make a donation',
  'payment.submission.paySubmission' => 'Pay Submission Fee',
  'payment.fastTrack.payFastTrack' => 'Pay to FastTrack',
  'payment.fastTrack.inFastTrack' => 'in FastTrack',
  'payment.publication.payPublication' => 'Pay to Publish',
  'payment.publication.publicationPaid' => 'Publication Fee Paid',
  'payment.membership.buyMembership' => 'Buy Individual Membership',
  'payment.membership.renewMembership' => 'Renew Individual Membership',
  'payment.membership.ends' => 'Ends',
  'payment.subscription.purchase' => 'Purchase Subscription',
  'payment.subscription.renew' => 'Renew Subscription',
  'payment.subscription.expires' => 'Expires',
  'installer.appInstallation' => 'OJS Installation',
  'installer.ojsUpgrade' => 'OJS Upgrade',
  'installer.installationInstructions' => '<h4>OJS Version {$version}</h4>

<p>Thank you for downloading the Public Knowledge Project\'s <strong>Open Journal Systems</strong>. Before proceeding, please read the <a href="{$baseUrl}/docs/README">README</a> file included with this software. For more information about the Public Knowledge Project and its software projects, please visit the <a href="http://pkp.sfu.ca/" target="_blank">PKP web site</a>. If you have bug reports or technical support inquiries about Open Journal Systems, see the <a href="http://forum.pkp.sfu.ca" target="_blank">support forum</a> or visit PKP\'s online <a href="https://github.com/pkp/pkp-lib#issues" target="_blank">bug reporting system</a>. Although the support forum is the preferred method of contact, you can also email the team at <a href="mailto:pkp.contact@gmail.com">pkp.contact@gmail.com</a>.</p>

<h4>Upgrade</h4>

<p>If you are upgrading an existing installation of OJS, <a href="{$upgradeUrl}">click here</a> to proceed.</p>

<h4>Recommended system requirements</h4>

<ul>
	<li><a href="http://www.php.net/" target="_blank">PHP</a> >= {$phpRequiredVersion}; you are currently using PHP {$phpVersion}{$wrongPhpText}</li>
	<li><a href="http://www.mysql.com/" target="_blank">MySQL</a> >= 4.1 or <a href="http://www.postgresql.org/" target="_blank">PostgreSQL</a> >= 9.1.5</li>
	<li><a href="http://httpd.apache.org/" target="_blank">Apache</a> >= 1.3.2x or >= 2.0.4x or Microsoft IIS 6</li>
	<li>Operating system: Any OS that supports the above software, including <a href="http://www.linux.org/" target="_blank">Linux</a>, <a href="http://www.bsd.org/" target="_blank">BSD</a>, <a href="http://www.oracle.com/sun/" target="_blank">Solaris</a>, <a href="http://www.apple.com/" target="_blank">Mac OS X</a>, <a href="http://www.microsoft.com/">Windows</a></li>
</ul>

<p>As PKP does not have the resources to test every possible combination of software versions and platforms, no guarantee of correct operation or support is implied.</p>

<p>Changes to these settings can be made after installation by editing the file <tt>config.inc.php</tt> in the base OJS directory, or using the site administration web interface.</p>

<h4>Supported database systems</h4>

<p>OJS has currently only been tested on MySQL and PostgreSQL, although other database management systems supported by <a href="http://adodb.sourceforge.net/" target="_blank">ADOdb</a> may work (in full or partially). Compatibility reports and/or code patches for alternative DBMSs can be sent to the OJS team.</p>',
  'installer.preInstallationInstructions' => '<h4>Pre-Installation Steps</h4>


<p>1. The following files and directories (and their contents) must be made writable:</p>
<ul>
	<li><tt>config.inc.php</tt> is writable (optional): {$writable_config}</li>
	<li><tt>public/</tt> is writable: {$writable_public}</li>
	<li><tt>cache/</tt> is writable: {$writable_cache}</li>
	<li><tt>cache/t_cache/</tt> is writable: {$writable_templates_cache}</li>
	<li><tt>cache/t_compile/</tt> is writable: {$writable_templates_compile}</li>
	<li><tt>cache/_db</tt> is writable: {$writable_db_cache}</li>
</ul>

<p>2. A directory to store uploaded files must be created and made writable (see "File Settings" below).</p>',
  'installer.upgradeInstructions' => '<h4>OJS Version {$version}</h4>

<p>Thank you for downloading the Public Knowledge Project\'s <strong>Open Journal Systems</strong>. Before proceeding, please read the <a href="{$baseUrl}/docs/README">README</a> and <a href="{$baseUrl}/docs/UPGRADE">UPGRADE</a> files included with this software. For more information about the Public Knowledge Project and its software projects, please visit the <a href="http://pkp.sfu.ca/" target="_blank">PKP web site</a>. If you have bug reports or technical support inquiries about Open Journal Systems, see the <a href="http://forum.pkp.sfu.ca" target="_blank">support forum</a> or visit PKP\'s online <a href="https://github.com/pkp/pkp-lib#issues" target="_blank">bug reporting system</a>. Although the support forum is the preferred method of contact, you can also email the team at <a href="mailto:pkp.contact@gmail.com">pkp.contact@gmail.com</a>.</p>
<p>It is <strong>strongly recommended</strong> that you back up your database, files directory, and OJS installation directory before proceeding.</p>
<p>If you are running in <a href="http://www.php.net/features.safe-mode" target="_blank">PHP Safe Mode</a>, please ensure that the max_execution_time directive in your php.ini configuration file is set to a high limit. If this or any other time limit (e.g. Apache\'s "Timeout" directive) is reached and the upgrade process is interrupted, manual intervention will be required.</p>',
  'installer.localeSettingsInstructions' => 'For complete Unicode (UTF-8) support, select UTF-8 for all character set settings. Please note that full Unicode support requires PHP to be compiled with support for the <a href="http://www.php.net/mbstring" target="_blank">mbstring</a> library (enabled by default in most recent PHP installations). You may experience problems using extended character sets if your server does not meet these requirements.
<br /><br />
Your server currently supports mbstring: <strong>{$supportsMBString}</strong>',
  'installer.allowFileUploads' => 'Your server currently allows file uploads: <strong>{$allowFileUploads}</strong>',
  'installer.maxFileUploadSize' => 'Your server currently allows a maximum file upload size of: <strong>{$maxFileUploadSize}</strong>',
  'installer.localeInstructions' => 'The primary language to use for this system. Please consult the OJS documentation if you are interested in support for languages not listed here.',
  'installer.additionalLocalesInstructions' => 'Select any additional languages to support in this system. These languages will be available for use by journals hosted on the site. Additional languages can also be installed at any time from the site administration interface.',
  'installer.filesDirInstructions' => 'Enter full pathname to an existing directory where uploaded files are to be kept. This directory should not be directly web-accessible. <strong>Please ensure that this directory exists and is writable prior to installation.</strong> Windows path names should use forward slashes, e.g. "C:/myjournal/files".',
  'installer.databaseSettingsInstructions' => 'OJS requires access to a SQL database to store its data. See the system requirements above for a list of supported databases. In the fields below, provide the settings to be used to connect to the database.',
  'installer.installApplication' => 'Install Open Journal Systems',
  'installer.upgradeApplication' => 'Upgrade Open Journal Systems',
  'installer.reinstallAfterDatabaseError' => '<strong>Warning:</strong> If installation failed part way through database installation you may need to drop your OJS database or database tables before attempting to reinstall the database.',
  'installer.overwriteConfigFileInstructions' => '<h4>IMPORTANT!</h4>
<p>The installer could not automatically overwrite the configuration file. Before attempting to use the system, please open <tt>config.inc.php</tt> in a suitable text editor and replace its contents with the contents of the text field below.</p>',
  'installer.installationComplete' => '<p>Installation of OJS has completed successfully.</p>
<p>To begin using the system, <a href="{$loginUrl}">login</a> with the username and password entered on the previous page.</p>
<p>If you wish to be part of the PKP community, you can:</p>
<ol>
	<li>Read the <a href="http://pkp.sfu.ca/blog" target="_new">PKP blog</a> and follow the <a href="http://pkp.sfu.ca/blog/feed" target="_new">RSS feed</a> for news and updates.</li>
	<li>Visit the <a href="http://forum.pkp.sfu.ca" target="_new">support forum</a> if you have questions or comments.</li>
</ol>',
  'installer.upgradeComplete' => '<p>Upgrade of OJS to version {$version} has completed successfully.</p>
<p>Don\'t forget to set the "installed" setting in your config.inc.php configuration file back to <em>On</em>.</p>
<p>If you haven\'t already registered and wish to receive news and updates, <strong>please register at <a href="http://pkp.sfu.ca/ojs/register" target="_new">http://pkp.sfu.ca/ojs/register</a>.</strong> If you have questions or comments, please visit the <a href="http://forum.pkp.sfu.ca" target="_new">support forum</a>.</p>',
  'site.upgradeAvailable.admin' => 'There is a new version of OJS available! You are currently using OJS {$currentVersion}. The most recent version is OJS {$latestVersion}. Please visit <a href="http://pkp.sfu.ca/ojs_download" target="_new">this page</a> to download the most recent version and find upgrade instructions.',
  'site.upgradeAvailable.manager' => 'There is a new version of OJS available! You are currently using OJS {$currentVersion}. The most recent version is OJS {$latestVersion}. Please contact your Site Administrator ({$siteAdminName}, <a href="mailto:{$siteAdminEmail}">{$siteAdminEmail}</a>) to notify them of this new release. More information can be found <a href="http://pkp.sfu.ca/ojs_download" target="_new">here</a>.',
  'log.author.documentRevised' => '{$authorName} has revised article {$submissionId}. The new file ID is {$fileId}.',
  'log.review.reviewerUnassigned' => '{$reviewerName} has been unassigned from reviewing submission {$submissionId} for review round {$round}.',
  'log.review.reviewInitiated' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been initiated.',
  'log.review.reviewReinitiated' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been reinitiated.',
  'log.review.reviewCancelled' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been cancelled.',
  'log.review.reviewCleared' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been cleared.',
  'log.review.reviewerRated' => '{$reviewerName} has been rated for the round {$round} review of submission {$submissionId}.',
  'log.review.reviewDueDateSet' => 'The due date for the round {$round} review of submission {$submissionId} by {$reviewerName} has been set to {$dueDate}.',
  'log.review.reviewRecommendationSet' => 'The recommendation for the round {$round} review of submission {$submissionId} by {$reviewerName} has been set.',
  'log.review.reviewRecommendationSetByProxy' => 'The recommendation for the round {$round} review of submission {$submissionId} has been set by the editor, {$editorName}, on behalf of the reviewer, {$reviewerName}.',
  'log.review.resubmit' => 'The submission {$submissionId} has been resubmitted for review.',
  'log.review.reviewDeclined' => '{$reviewerName} has declined the round {$round} review for submission {$submissionId}.',
  'log.review.reviewAccepted' => '{$reviewerName} has accepted the round {$round} review for submission {$submissionId}.',
  'log.review.reviewDeclinedByProxy' => '{$userName} has declined the round {$round} review for submission {$submissionId} on behalf of {$reviewerName}.',
  'log.review.reviewAcceptedByProxy' => '{$userName} has accepted the round {$round} review for submission {$submissionId} on behalf of {$reviewerName}.',
  'log.review.reviewFileByProxy' => 'The Editor, {$userName}, has uploaded a review file for round {$round} of submission {$submissionId} on behalf of the reviewer, {$reviewerName}.',
  'log.review.reviewerFile' => 'A reviewer file has been uploaded.',
  'log.editor.decision' => 'An editor decision ({$decision}) for article {$submissionId} was recorded by {$editorName}.',
  'log.copyedit.initiate' => 'Copyediting on submission {$submissionId} has been commenced by {$copyeditorName}.',
  'log.copyedit.copyeditFileSet' => 'The default copyedit file has been chosen.',
  'log.copyedit.initialEditComplete' => '{$copyeditorName} has completed the initial copy edit of submission {$submissionId}.',
  'log.copyedit.finalEditComplete' => '{$copyeditorName} has completed the final copy edit of submission {$submissionId}.',
  'log.copyedit.copyeditorAssigned' => '{$copyeditorName} has been assigned to copyedit submission {$submissionId}.',
  'log.copyedit.copyeditorFile' => 'A copyeditor version of the submission file has been uploaded.',
  'log.copyedit.authorFile' => 'A version of the submission file copyedited by the author has been uploaded.',
  'log.layout.layoutEditorAssigned' => '{$editorName} has been assigned as layout editor for submission {$submissionId}.',
  'log.layout.layoutEditorUnassigned' => '{$editorName} has been unassigned as layout editor for submission {$submissionId}.',
  'log.layout.layoutEditComplete' => '{$editorName} has completed layout editing for submission {$submissionId}.',
  'log.editor.metadataModified' => 'The metadata for this article was modified by {$editorName}.',
  'log.editor.editorFile' => 'An editor version of the submission file has been uploaded.',
  'log.editor.archived' => 'The submission {$submissionId} has been archived.',
  'log.editor.restored' => 'The submission {$submissionId} has been restored to the queue.',
  'log.editor.editorAssigned' => '{$editorName} has been assigned as editor to submission {$submissionId}.',
  'log.proofread.assign' => '{$assignerName} has assigned {$proofreaderName} to proofread submission {$submissionId}.',
  'log.proofread.complete' => '{$proofreaderName} has submitted {$submissionId} for scheduling.',
  'log.imported' => '{$userName} has imported article {$submissionId}.',
  'rt.admin.settings' => 'Reading Tool Options',
  'rt.admin.settings.description' => 'The reading tools appear in a frame beside published items in the sections of the journal that have been designated for indexing. The reading tools consist of a set of optional tools related to the published item, listed below, and a set of tools that provide access to related items, organized by field and discipline.',
  'rt.admin.settings.enableReadingTools' => 'Enable Reading Tools for designated sections of journal.',
  'rt.admin.settings.relatedItems' => 'Field',
  'rt.admin.settings.relatedItemsLink' => 'See <a href="{$relatedItemsLink}" class="action">Related Items Sets</a> to view, add, correct, or delete related items for each field.',
  'rt.admin.options' => 'Journal Item Tools',
  'rt.admin.relatedItems' => 'Related Item Tools',
  'rt.admin.settings.addComment' => 'Add comment (enables readers to post comments, with Journal Manager able to delete).',
  'rt.admin.settings.addComment.authenticated' => 'Users must be registered and logged in to post, with anonymity not permitted.',
  'rt.admin.settings.addComment.anonymous' => 'Users must be registered and logged in to post, with anonymity permitted.',
  'rt.admin.settings.addComment.unauthenticated' => 'Users do not need to be registered to post, with anonymity permitted.',
  'rt.admin.validateUrls.description' => 'Possibly invalid URLs for search sites are displayed below.<br/>
You should manually verify any URLs marked as invalid, as this test is not 100% accurate.<br/>
Validation may fail on search URLs that require posted form data.',
  'rt.metadata.dublinCore.primaryAuthor' => 'Creator',
  'rt.metadata.pkp.primaryAuthor' => 'Author\'s name, affiliation, country',
  'rt.metadata.pkp.peerReviewed' => 'Peer-reviewed Article',
  'rt.beNotifiedWhen' => 'Be notified when...',
  'rt.thisJournal' => 'Search journal',
  'rt.context.authorTermsDescription' => 'For items with more than one author, leave all names checked to search for similarly co-authored work, or search one at a time by checking only a single name. To learn more about the resource searched, click on ABOUT. These resources have been selected because of their relevance and their open (free) access to all or part of their contents.',
  'notification.mailListDescription' => 'Enter your email address to receive immediate notifications of important new content added to the journal.',
  'notification.notificationsPublicDescription' => 'This page shows important updates associated with this journal such as new issues or announcements.  You may subscribe to these notifications through RSS feeds (by clicking on the images to the right), or   <a href="{$emailUrl}">through email.</a>',
  'notification.type.articleSubmitted' => 'A new article, "{$title}", has been submitted.',
  'notification.type.editing' => 'Editing Events',
  'notification.type.submissionSubmitted' => 'A new article, "{$title}," has been submitted.',
  'notification.type.editorDecisionComment' => 'A comment has been left on the editor decision for "{$title}."',
  'notification.type.galleyModified' => 'A galley has been modified for "{$title}."',
  'notification.type.issuePublished' => 'An issue has been published.',
  'notification.type.newAnnouncement' => 'A new announcement has been created.',
  'notification.type.reviewerFormComment' => 'A review form review has been submitted for "{$title}."',
  'notification.type.reviewing' => 'Reviewing Events',
  'notification.type.site' => 'Site Events',
  'notification.type.submissionComment' => 'An editor has made a comment on "{$title}."',
  'notification.type.submissions' => 'Submission Events',
  'notification.type.userComment' => 'A reader has made a comment on "{$title}"',
  'notification.savedIssueMetadata' => 'Issue publication metadata saved.',
  'notification.type.editorAssignmentTask' => 'A new article has been submitted to which an editor needs to be assigned.',
  'notification.type.assignProductionUser' => 'Assign a user to create galleys using the Add link in the Participants list.',
  'notification.type.awaitingRepresentations' => 'Awaiting Galleys.',
  'user.authorization.copyeditorAssignmentMissing' => 'Access denied! You have not been assigned as a copyeditor to this article.',
  'user.authorization.noContext' => 'No journal in context!',
  'user.authorization.sectionAssignment' => 'You are trying to access an article that is not part of your section.',
  'user.authorization.invalidIssue' => 'Invalid issue requested!',
  'user.authorization.invalidCopyditorSubmission' => 'Invalid copyeditor submission or no copyeditor submission requested!',
  'debug.notes.currencyListLoad' => 'Loaded currency list "{$filename}" from XML',
  'grid.action.createContext' => 'Create a New Journal',
  'editor.navigation.issues' => 'Issues',
  'notification.type.approveSubmission' => 'This submission is currently awaiting approval before it will appear in the issue.',
  'notification.type.approveSubmissionTitle' => 'Awaiting approval.',
  'user.profile.form.showOtherContexts' => 'Register with other journals',
  'user.profile.form.hideOtherContexts' => 'Hide other journals',
  'article.view.interstitial' => 'Please choose an article file to download.',
  'grid.catalogEntry.availableRepresentation.approved' => 'Approved',
  'grid.catalogEntry.availableRepresentation.notApproved' => 'Awaiting Approval',
  'grid.catalogEntry.approvedRepresentation.title' => 'Galley Approval',
  'grid.catalogEntry.approvedRepresentation.message' => '<p>Approve this galley for publication.</p>',
  'grid.catalogEntry.approvedRepresentation.removeMessage' => '<p>Remove approval of this galley.</p>',
  'search.cli.rebuildIndex.indexing' => 'Indexing "{$journalName}"',
  'search.cli.rebuildIndex.indexingByJournalNotSupported' => 'This search implementation does not allow per-journal re-indexing.',
  'search.cli.rebuildIndex.unknownJournal' => 'The given journal path "{$journalPath}" could not be resolved to a journal.',
  'editor.issues.backIssues' => 'Back Issues',
  'editor.issues.futureIssues' => 'Future Issues',
); ?>